#include "SimpleXML.h"
#include <iostream>
#include <sstream>
#include <cstdio>

using namespace std;

xmlNodePtr getNode( string nodeName, xmlNodePtr root){
    if( root != NULL) {
        for( xmlNodePtr node = root->children; node; node = node->next) {
            if( xmlStrcmp( node->name, BAD_CAST nodeName.data()) == 0){        
                return node;
            }
        }
    }
    return NULL;    
}

xmlNodePtr getNextNode( std::string nodeName, xmlNodePtr node){
    if( node != NULL) {
        for( ; node; node = node->next) {
            if( xmlStrcmp( node->name, BAD_CAST nodeName.data()) == 0){        
                return node;
            }
        }
    }
    return NULL;    
}


int getAttr( int &dest, std::string atrName, xmlNodePtr node){
    if( node != NULL) {
        for( xmlAttrPtr attr = node->properties; attr; attr = attr->next) {
            int result;
            if( xmlStrcmp( attr->name, BAD_CAST atrName.data()) == 0){        
                if( attr->children != NULL){
                    if( sscanf( (const char*)attr->children->content, "%d", &result) != 1) {
                        return 0;
                    } else {
                        dest = result;
                        return 1;
                    }
                } else {
                    return 0;   
                }
            }
        }
    }
    return 0;
}

int getAttr( double &dest, std::string atrName, xmlNodePtr node){
    if( node != NULL) {
        for( xmlAttrPtr attr = node->properties; attr; attr = attr->next) {
            float result;
            if( xmlStrcmp( attr->name, BAD_CAST atrName.data()) == 0){        
                if( attr->children != NULL){
                    if( sscanf( (const char*)attr->children->content, "%f", &result) != 1) {
                        return 0;
                    } else {
                        dest = result;
                        return 1;
                    }
                } else {
                    return 0;   
                }
            }
        }
    }
    return 0;
}
    
int getAttr( string &dest, std::string atrName, xmlNodePtr node){
    if( node != NULL) {
        for( xmlAttrPtr attr = node->properties; attr; attr = attr->next) {
            if( xmlStrcmp( attr->name, BAD_CAST atrName.data()) == 0){        
                if( attr->children != NULL){
                    dest = (const char*)attr->children->content;
                    return 1;
                } 
            }
        }
    }
    return 0;
}

int getAttr( bool &dest, std::string atrName, xmlNodePtr node){
    if( node != NULL) {
        for( xmlAttrPtr attr = node->properties; attr; attr = attr->next) {
            if( xmlStrcmp( attr->name, BAD_CAST atrName.data()) == 0){        
                if( attr->children != NULL){
                    dest = xmlStrcmp( attr->children->content, BAD_CAST "true") == 0;
                    return 1;
                } 
            }
        }
    }
    return 0;
}

string getAttr( std::string atrName, xmlNodePtr node){
    if( node != NULL) {
        for( xmlAttrPtr attr = node->properties; attr; attr = attr->next) {
            if( xmlStrcmp( attr->name, BAD_CAST atrName.data()) == 0){     
                if( attr->children != NULL){
                    return (const char*)attr->children->content;
                }
            }
        }
    }
    return "";
}

xmlAttrPtr getAttrNode(std::string atrName, xmlNodePtr node)
{
    if (node != NULL)
    {
        xmlAttrPtr attr;
        for (attr = node->properties; attr; attr = attr->next)
        {
            if (xmlStrcmp(attr->name, BAD_CAST atrName.data()) == 0)
                return attr;
        }
    }
    return NULL;
}


TXMLOutput::TXMLOutput( ): rootNode( NULL), cur( NULL), buffer( xmlBufferCreate()){
    
}

TXMLOutput::~TXMLOutput( ){
    xmlBufferFree( buffer);
    if( rootNode){
        xmlFreeNode( rootNode);   
    }
}

void TXMLOutput::addElement( const string elementName){
    if( rootNode == NULL){
        rootNode = cur = xmlNewNode( NULL, (const xmlChar *) elementName.data());
    } else {
        cur = xmlNewChild( cur, NULL, (const xmlChar *) elementName.data(), NULL);   
    }
}

void TXMLOutput::addAttribute( const string name, const string value){
    if( cur){
        xmlNewProp( cur, (const xmlChar *) name.data(), (const xmlChar *) value.data());        
    } 
}

void TXMLOutput::addAttribute( const string name, const int value){
    if( cur){
        stringstream s;
        s << value;
        xmlNewProp( cur, (const xmlChar *) name.data(), (const xmlChar *) s.str().data());        
    }
}

void TXMLOutput::addAttribute( const string name, const double value){
    if( cur){
        stringstream s;
        s << value;
        xmlNewProp( cur, (const xmlChar *) name.data(), (const xmlChar *) s.str().data());        
    }
}


void TXMLOutput::endElement(){
    if( cur != rootNode){
        cur = cur->parent;
    }
}

void TXMLOutput::addText( const std::string &text){
    xmlNodeAddContent( cur, (const xmlChar *)text.data());
}

char * TXMLOutput::getText( int indentDepth){
    xmlBufferEmpty( buffer);
    
    xmlNodeDump( buffer, NULL, rootNode, indentDepth, 1);
    return (char *) buffer->content;
}
    
char * TXMLOutput::getText( int indentDepth, xmlNodePtr node){
    xmlBufferEmpty( buffer);
    
    xmlNodeDump( buffer, NULL, node, indentDepth, 1);
    return (char *) buffer->content;
}
    
xmlNodePtr TXMLOutput::getRootNode(){
    return rootNode;   
}
