#include <cstdlib>
#include <iostream>
#include <fstream>
#include <vector>

using namespace std;

/// Header of .raw files
static const char rawHeader[5] = "S2D ";

ifstream * getRAWInfo(string & filename, unsigned & width, unsigned & height, unsigned & sampleCount);

int main(int argc, char *argv[])
{
     
    vector<string> rawFileNames;
    string outputFileName;
    string annotationFileName;
    int numberOfSamples = -1;
    bool textAnnotaion = false;
    
    string sampleClass;
    
    for (int i = 1; i < argc; i++) {
        if (strcmp( argv[i],"-o") == 0){
            annotationFileName = outputFileName = argv[ ++i];
        } else if (strcmp( argv[i],"-h") == 0){
            cout << " merge.exe -o outputFile file1.raw file2.raw [ file2.raw ...] [-a]" << endl;
			cout << " -a	Will create annotation file. Each intput raw file represents one class." << endl;
			cout << endl;
            exit(1);
        } else if (strcmp( argv[i],"-a") == 0){
            textAnnotaion = true;
        } else {
            rawFileNames.push_back( argv[ i]);    
        }
    }
    annotationFileName += ".txt";
    outputFileName += ".raw";
    
    
    if( rawFileNames.empty()){
        cout << "Use -o output.raw file1.raw file2.raw [ file2.raw ...]" << endl;
        cout << "Use -h to get more help." << endl;
        exit(1);
    }
    
    
    unsigned width = 0;
    unsigned height = 0;
    unsigned totalSampleCount = 0;

    long imageCountPosition;
    ofstream *outputFile = NULL;

    outputFile = new ofstream( outputFileName.data(), ios::binary | ios::trunc);
    cout << outputFile->good() << endl;
    if( !outputFile->good()){
        cout << "ERROR: Unable to open output file " << outputFileName << "." << endl;
        exit( 1);
    }
    outputFile->write( "S2D ", 4);
    imageCountPosition = outputFile->tellp();    
    outputFile->write( (char *) &totalSampleCount, 4);
    outputFile->write( (char *) &width , 4);
    outputFile->write( (char *) &height, 4);

    vector<string>::iterator rawFileName;
    
    ofstream *annotationFile = NULL;
    if( textAnnotaion){
        annotationFile = new ofstream( annotationFileName.data(), ios::trunc);
        
        *annotationFile << "# Classes: ";
        for( int i = 0; i < rawFileNames.size(); i++){
            *annotationFile << rawFileNames[ i] << ' ';           
        }
        *annotationFile << endl;
    }
    
    int collumn = -1;
    for( rawFileName = rawFileNames.begin(); rawFileName != rawFileNames.end(); rawFileName++){

        collumn++;
        unsigned sampleCount = 0;
        unsigned tempWidth = 0;
        unsigned tempHeight = 0;
        ifstream * rawFile = getRAWInfo( *rawFileName, tempWidth, tempHeight, sampleCount);

        if (!rawFile){
            cout << "Error: unable to open file " << *rawFileName << "." << endl;
            continue;  
        }
        
        cout << " widht: " << tempWidth << " height " << tempHeight << endl;
        if( totalSampleCount != 0 && ( width != tempWidth || height != tempHeight)){
            cout << "Erroor: Wrong sample size in raw file " << *rawFileName << "." << endl;
            continue;
        }

        width = tempWidth;
        height = tempHeight;
        
        char * image = new char[ width*height];
    
        for( unsigned writtenSamples = 0; writtenSamples < sampleCount; writtenSamples++, totalSampleCount++){

            rawFile->read( image, width*height);

            if( !rawFile->good()){
                cout << "Error: Corrupted raw file. Sample count not valid in file " << *rawFileName << "." << endl;
                exit( 1);     
            }

            if( annotationFile){
                for( int i = 0; i < rawFileNames.size(); i++){
                    if( collumn == i){
                        *annotationFile << "1 ";
                    } else {
                        *annotationFile << "0 ";
                    }
                }
                *annotationFile << endl;
            }

            outputFile->write( image, width*height);

        }

        rawFile->close();
        delete rawFile;    
    }   

    outputFile->seekp( imageCountPosition);
    outputFile->write( (char *) &totalSampleCount, 4);
    outputFile->write( (char *) &width , 4);
    outputFile->write( (char *) &height, 4);
    outputFile->close();
    delete outputFile;
    
    if( annotationFile != NULL){
        annotationFile->close();
        delete annotationFile;
    }

    return EXIT_SUCCESS;
}

ifstream * getRAWInfo(string & filename, unsigned & width, unsigned & height, unsigned & sampleCount)
{
    ifstream * p_fr = new ifstream(filename.c_str(), ios::binary);
    
    if( !p_fr->good())
    {
        cerr << "Warning: Unable to open raw file " << filename << '.' << endl;
        p_fr->close();
        delete p_fr;
        return NULL;
    }
    
    char header[5];
    p_fr->read((char*)header, 4);

    if ( strncmp(header, rawHeader, 4) != 0)
    {
        cerr << "Warning: Wrong file or sample format." << endl;
        p_fr->close();
        delete p_fr;
        return NULL;
    }

    p_fr->read((char*)(&sampleCount), 4);
    p_fr->read((char*)(&width), 4);
    p_fr->read((char*)(&height), 4);

    if( !p_fr->good()){
        p_fr->close();
        delete p_fr;
        return NULL;
    }

    return p_fr;
} // getRawInfo()


struct TRecord{
    string name, surname, sex, age;
};



void getLine( char * buffer, int bufferSize, FILE * inFile){
    int i = 0;
    char ch = ' ';
    
    while( !feof( inFile) && i < bufferSize - 10 && ch != '\n' ){

        ch = buffer[ i] = fgetc( inFile);
        i++;
    }
    
    if( i == bufferSize - 10){
        // vypis, ze je radek moc dlouhej
        exit( -1);
    }
    
    buffer[ i] = 0;
    buffer[ i + 1] = 0;
    buffer[ i + 2] = 0;
    buffer[ i + 3] = 0;
}

char * getWord( char * buffer){

    while( *buffer != 0 && *buffer != ';'){
        buffer++;
    }
    
    return buffer;
}
/*

    FILE * inFile; // nejak se to otevre a zkontroluje, jestli to probehlo v pohode

    const int bufferSize = 10000;
    char buffer[ bufferSize];

    vector< TRecord> records;
    
    while( !feof( ifFile)){

        getLine( buffer, bufferSize, inFile);
        
        char name[ bufferSize], surname[ bufferSize], sex[ bufferSize], age[ bufferSize];
        TRecord newRecord;
        
        char *begin = buffer;
        char *end = getWord( buffer);

        int pos = 0;
        for( char * i = begin; i != end; i++){
            name[ pos] = *i;
            pos++
        }
        name[ pos] = 0;
        
        begin = end + 1;
        end = getWord( buffer);
        
        pos = 0;
        for( char * i = begin; i != end; i++){
            surname[ pos] = *i;
            pos++
        }
        
        
        name[ pos] = 0;
        begin = end + 1;
        end = getWord( buffer);

        pos = 0;
        for( char * i = begin; i != end; i++){
            sex[ pos] = *i;
            pos++
        }



        begin = end + 1;
        end = getWord( buffer);
        pos = 0;
        for( char * i = begin; i != end; i++){
            age[ pos] = *i;
            pos++
        }

        // nekam to ulozit
    }
    //uzavrit soubor
}*/




