// type Matrix
typedef struct _Matrix {
        float **data;
        int   rows_nb;
        int   lines_nb;
} Matrix;

// matrix computing prototypes
Matrix newMatrix(int lines_nb, int rows_nb, float init_value);
Matrix newPoint(float dx, float dy, float dt);
Matrix multMatrix(Matrix A, Matrix B);
Matrix addMatrix(Matrix A, Matrix B);
float pointXCoord(Matrix point);
float pointYCoord(Matrix point);
void displayMatrix(Matrix matrix);
void freeMatrix (Matrix matrix);
void identityMatrix(Matrix &matrix);

// transformation matrix prototypes
Matrix newRotationMatrix(float theta);
Matrix newTranslationMatrix(float dx, float dy, float dt);
Matrix newScaleMatrix(float sx, float sy);
Matrix newShearMatrix(float sx, float sy);
Matrix newTransfMat();
void updateTransfMat(Matrix &R, Matrix M);
