#define TOKEN_MAXSIZE 100

#include <vector>

struct Range{
        float min;
        float max;
};


typedef std::vector< string> ClassInfo;

typedef struct _Config {
        int             transformation_nb;   // nb of trans to make on each image
        Range           rotation;            // rotation range
        Range           shiftX;              // shiftX range
        Range           shiftY;              // shiftY range
        Range           shearX;              // shearX range
        Range           shearY;              // shearY range
        Range           scale;               // scale range
        Range           brightness;          // brightness range
        Range           contrast;            // contrast range
        Range           gamma;               // gamma range
        Resolution      output_resolution;   // resolution of output images
        double          gaussianNoiseSTDDev;          
        bool            configOK;
} Config;

struct TObject{
    std::string   sub_class;
    Coordinates   roi_LeftBottom;
    Coordinates   roi_LeftTop;
    Coordinates   roi_RightBottom;
    Coordinates   roi_RightTop; 
};

struct TAnnotation{
    TAnnotation( const string _imageName): imageName( _imageName){}
    
    std::string     imageName;
    std::vector< TObject>  objects;
    
} ;


Config loadConfiguration(string config_name);
void loadAnnotation( string annotationFileName, vector< TAnnotation> &annotations);
