/* RandomAnnotation - creates random annotation for images. For nonface data.*/
/* Author: Michal Hradis @ UPMG FIT VUTBR */
/* Date: 26.3.2007 */


#include "Image.h"
#include "ImageFil.h"
#include <stdlib.h>
#include <iostream>
using namespace std; 
 
int main(int argc, char *argv[])
{
    ImageStruct *inputImage;

    const int targetNumberOfSamples = atoi( argv[ 2]);
    
    int numberOfSamples = 0;
    for( int i = 3; i < argc && numberOfSamples < targetNumberOfSamples; i++){
        cerr << " Openning image: " << argv[ i] << endl;
        inputImage = CreateImageFile( argv[ i], 0, NULL, NULL);
        
        if( inputImage == NULL){
            cerr << "ERROR: Unable to load image " << argv[ i] << endl;
            continue;
        }
   
        int sizeX = inputImage->XSize;
        int sizeY = inputImage->YSize;
        
        cout << "<image>  " << argv[ i] << endl;
            
        for( int j = 0; j < 20; j++){
            int size = rand() % sizeX % sizeY;
            int posX = rand() % ( sizeX - size);
            int posY = rand() % ( sizeY - size); 
            
            cout << "    <object> " << endl;
            cout << "        obj_type = rectangle" << endl;
            cout << "        sub_class        = " << argv[ 1] << endl;
            cout << "        roi_LeftTop      = " << posX << ":" << posY << endl;
            cout << "        roi_LeftBottom   = " << posX << ":" << posY + size << endl;
            cout << "        roi_RightTop     = " << posX + size << ":" << posY << endl;
            cout << "        roi_RightBottom  = " << posX + size << ":" << posY + size << endl;
            cout << "    </object> " << endl;
            numberOfSamples++;
        }
        cout << "</image>" << endl;   
        DeleteImage( inputImage);  
    }
    
    cerr << " Total saple count: " << numberOfSamples << endl;
    exit( 1);
 }
