#include "main.h"
#include "matrix.h"

// newRotationMatrix -----------------------------------------------------------
//
// description : creates a rotation matrix of the chosen angle
//               
// arguments :   float theta   -      the rotation angle in radians
// -----------------------------------------------------------------------------

Matrix newRotationMatrix(float theta)
{
    Matrix rotation_matrix;
    
    rotation_matrix = newMatrix(3,3,0);
    
    rotation_matrix.data[0][0] = cos(theta);     rotation_matrix.data[0][1] = -sin(theta);    rotation_matrix.data[0][2] = 0;
    rotation_matrix.data[1][0] = sin(theta);     rotation_matrix.data[1][1] = cos(theta);     rotation_matrix.data[1][2] = 0;
    rotation_matrix.data[2][0] = 0;              rotation_matrix.data[2][1] = 0;              rotation_matrix.data[2][2] = 1;
    
    return rotation_matrix;
}

// newTranslationMatrix --------------------------------------------------------
//
// description : creates a translation matrix of the chosen vector
//               
// arguments :   float dx   -      the x axis translation value
//               float dy   -      the y axis translation value
//               float dt   -      normalisation value
// -----------------------------------------------------------------------------

Matrix newTranslationMatrix(float dx, float dy, float dt)
{   
    Matrix translation_matrix;
    
    translation_matrix = newMatrix(3,3,0);
    
    translation_matrix.data[0][0] = 1;     translation_matrix.data[0][1] = 0;     translation_matrix.data[0][2] = dx;
    translation_matrix.data[1][0] = 0;     translation_matrix.data[1][1] = 1;     translation_matrix.data[1][2] = dy;
    translation_matrix.data[2][0] = 0;     translation_matrix.data[2][1] = 0;     translation_matrix.data[2][2] = dt;
    
    return translation_matrix;
}

// newScaleMatrix --------------------------------------------------------------
//
// description : creates a scale matrix
//               
// arguments :   float sx   -      the x axis scaling value
//               float sy   -      the y axis scaling value
// -----------------------------------------------------------------------------

Matrix newScaleMatrix(float sx, float sy)
{   
    Matrix scale_matrix;
    
    scale_matrix = newMatrix(3,3,0);
    
    scale_matrix.data[0][0] = sx;     scale_matrix.data[0][1] = 0;      scale_matrix.data[0][2] = 0;
    scale_matrix.data[1][0] = 0;      scale_matrix.data[1][1] = sy;     scale_matrix.data[1][2] = 0;
    scale_matrix.data[2][0] = 0;      scale_matrix.data[2][1] = 0;      scale_matrix.data[2][2] = 1;
    
    return scale_matrix;
}

// newShearMatrix --------------------------------------------------------------
//
// description : creates a shear matrix
//               
// arguments :   float sx   -      the x axis shearing value
//               float sy   -      the y axis shearing value
// -----------------------------------------------------------------------------

Matrix newShearMatrix(float sx, float sy)
{   
    Matrix shear_matrix;
    
    shear_matrix = newMatrix(3,3,0);
    
    shear_matrix.data[0][0] = 1;     shear_matrix.data[0][1] = sx;    shear_matrix.data[0][2] = 0;
    shear_matrix.data[1][0] = sy;    shear_matrix.data[1][1] = 1;     shear_matrix.data[1][2] = 0;
    shear_matrix.data[2][0] = 0;     shear_matrix.data[2][1] = 0;     shear_matrix.data[2][2] = 1;
    
    return shear_matrix;
}

// newTransfMat ----------------------------------------------------------------
//
// description : creates a global transformation matrix. It is initialized to
//               identity at first and then updated with other transformation
//               matrix in order to combine all the transformations in a single
//               matrix.
//               
// arguments :   none
// -----------------------------------------------------------------------------

Matrix newTransfMat()
{
    Matrix R;
    R = newMatrix(3,3,0);
    identityMatrix(R);
    
    return R;
}

// updateTransfMat -------------------------------------------------------------
//
// description : functions that updates a global transformation matrix with a
//               transformation matrix making a single transformation (i.e.
//               rotation, translation...)
//               
// arguments :   Matrix &R       -          the global transformation matrix          
//               Matrix M        -          the specific trandformation matrix  
// -----------------------------------------------------------------------------

void updateTransfMat(Matrix &R, Matrix M)
{
    Matrix RR = multMatrix(R, M);
    freeMatrix( R);
    R = RR;
}
