#include "main.h"
#include "matrix.h"

// newMatrix -------------------------------------------------------------------
//
// description : creates a new matrix
//               
// arguments :  int lines_nb         -      number of lines of the new matrix
//              int rows_nb          -      number of rows of the new matrix
//              float init_value     -      value to initialize the matrix
// -----------------------------------------------------------------------------

Matrix newMatrix(int lines_nb, int rows_nb, float init_value)
{
      Matrix matrix;
      
      int i,j;

      matrix.data = (float **) malloc( sizeof(float *) * lines_nb );
      
      for (i=0 ; i < lines_nb ; i++)
      {
          matrix.data[i] = (float *) malloc( sizeof(float) * rows_nb);
          
          for (j=0 ; j < rows_nb ; j++)
              matrix.data[i][j] = init_value;
      }

      matrix.lines_nb = lines_nb;
      matrix.rows_nb = rows_nb;

      return matrix;
}

//  --------------------------------------------------------------------
//
// description : creates a new point matrix. It is only a matrix of the relevant
//               dimensions to contain the homogeneous coordinates of a point.
//               
// arguments :  float x         -      x coordinate
//              float y         -      y coordinate
//              float t         -      normalization value
// -----------------------------------------------------------------------------

Matrix newPoint(float x, float y, float t)
{
    Matrix point;
    
    point = newMatrix(3,1,0);
    point.data[0][0] = x;
    point.data[1][0] = y;
    point.data[2][0] = t;

   return point;
}

// pointXCoord -----------------------------------------------------------------
//
// description : gets the normalized x coordinate of of point matrix.
//               
// arguments :  Matrix point    -      a point
// -----------------------------------------------------------------------------

float pointXCoord(Matrix point)
{
    if ( (point.lines_nb == 3) && (point.rows_nb == 1) )
    {
        return point.data[0][0]/point.data[2][0];
    }
    else
    {
        printf("Error: given matrix is not a point\n");
        system("PAUSE");
        exit(0);
    }
}

// pointYCoord -----------------------------------------------------------------
//
// description : gets the normalized y coordinate of of point matrix.
//               
// arguments :  Matrix point    -      a point
// -----------------------------------------------------------------------------

float pointYCoord(Matrix point)
{
    if ( (point.lines_nb == 3) && (point.rows_nb == 1) )
    {
        return point.data[1][0]/point.data[2][0];
    }
    else
    {
        printf("Error: given matrix is not a point\n");
        system("PAUSE");
        exit(0);
    }
}

// displayMatrix ---------------------------------------------------------------
//
// description : simple function to display a matrix.
//               
// arguments :  Matrix matrix    -      a matrix
// -----------------------------------------------------------------------------

void displayMatrix(Matrix matrix)
{
     int i,j;     
     
     for (i=0 ; i < matrix.lines_nb ; i++)
     { 
         for (j=0 ; j < matrix.rows_nb ; j++)
         { 
             printf("%f ", matrix.data[i][j]);
         }
         printf("\n");
     }
     printf("\n");
}

// freeMatrix ------------------------------------------------------------------
//
// description : frees the memory allocated for the matrix data.
//               
// arguments :  Matrix matrix    -      a matrix
// -----------------------------------------------------------------------------

void freeMatrix(Matrix matrix)
{
     int i;
     
     for (i=0 ; i < matrix.lines_nb ; i++)
     {     
           free(matrix.data[i]);
     }
     free(matrix.data);      
}

// multMatrix ------------------------------------------------------------------
//
// description : multiplies matrix A by matrix B (in this order). The matrix
//               dimensions have to be compatible. If not, the program stops.
//               
// arguments :  Matrix A    -      a matrix
//              Matrix B    -      a matrix
// -----------------------------------------------------------------------------

Matrix multMatrix(Matrix A, Matrix B)
{
    int i,j,k;
    Matrix result;
    
    result = newMatrix(A.lines_nb, B.rows_nb, 0);
    
    
    if(A.rows_nb == B.lines_nb) // checks dimensions compatibility
    {
        for(i=0; i < A.lines_nb ; i++)
            for(j=0; j < B.rows_nb ; j++)
            {
                for(k=0 ; k < A.rows_nb ; k++)
                result.data[i][j] += A.data[i][k] * B.data[k][j];
            }
    }
    else
    {
        printf("Error: matrix multiplication impossible, dimensions incompatible\n");
        system("PAUSE");
        exit(0);
    }
    
    return result;       
}

// addMatrix -------------------------------------------------------------------
//
// description : adds matrix A to matrix B . The matrix dimensions have to be 
//               compatible. If not, the program stops.
//               
// arguments :  Matrix A    -      a matrix
//              Matrix B    -      a matrix
// -----------------------------------------------------------------------------

Matrix addMatrix(Matrix A, Matrix B)
{
    int i,j;
    Matrix result;
    
    result = newMatrix(A.lines_nb, A.rows_nb, 0);
    
    if ( (A.rows_nb == B.rows_nb) && (A.lines_nb == B.lines_nb) )// checks dimensions compatibility
    {
        for(i=0; i < A.lines_nb ; i++)
            for(j=0; j < B.rows_nb ; j++)
            {
                result.data[i][j] = A.data[i][j] + B.data[i][j];
            }
    }
    else
    {
        printf("Error: matrix addition impossible, dimensions incompatible\n");
        system("PAUSE");
        exit(0);
    }
    
    return result;     
}

// identityMatrix --------------------------------------------------------------
//
// description : funstion used to initialize a matrix to the identity matrix.
//               
// arguments :  Matrix &matrix    -      a matrix
// -----------------------------------------------------------------------------

void identityMatrix(Matrix &matrix)
{
    int i,j;
    
    if(matrix.lines_nb == matrix.rows_nb)
    {
       for(i=0; i < matrix.lines_nb ; i++)
            for(j=0; j < matrix.rows_nb ; j++)
            {
                if (i==j) matrix.data[i][j] = 1;
                else matrix.data[i][j] = 0;
            }
    }
    else
    {
        printf("Error: the matrix is not a square matrix\n");
        system("PAUSE");
        exit(0);
    }     
}
