#include "main.h"
#include "illumination.h"


// linearCorrection ------------------------------------------------------------------
//
// description : function that returns an array containing the new values of the pixels.
//               The function makes a linear correction of the illumination, that is to 
//               say brightness and contrast.
//               
// arguments :   Image8Value * illuminationArray     -   the array containing the new pixel values
//               float brightness                    -   the brightness coefficient
//               float contrast                      -   the contrast coefficient
// -----------------------------------------------------------------------------

void linearCorrection(Image8Value * illuminationArray, float brightness, float contrast)
{
    int i;
    
    for(i=0 ; i<256 ; i++)
    {
            if (contrast*i + brightness > 255) illuminationArray[i] = 255;
            else if (contrast*i + brightness < 0  ) illuminationArray[i] = 0;    
            else illuminationArray[i] = (Image8Value)(contrast*i + brightness);
    }
}

// gammaCorrection -------------------------------------------------------------
//
// description : function that returns an array containing the new values of the pixels.
//               The function makes a gamma correction.
//               
// arguments :   Image8Value * illuminationArray     -   the array containing the new pixel values
//               float gamma                         -   the gamma coefficient
// -----------------------------------------------------------------------------

void gammaCorrection(Image8Value *illuminationArray, float gamma)
{
    int i;
    float normalized_pixel;
    
    for(i=0 ; i<256 ; i++)
    {
            normalized_pixel = (float)illuminationArray[i]/255.f;
            if      ( (float)pow( (double)normalized_pixel, (double)1/gamma) > 255) illuminationArray[i] = 255;
            else if ( (float)pow( (double)normalized_pixel, (double)1/gamma) < 0  ) illuminationArray[i] = 0;    
            else illuminationArray[i] = (Image8Value)( (float)pow((double)normalized_pixel,(double)1/gamma) * 255.f);
    }
}

// changeIllumination ----------------------------------------------------------
//
// description : this function applies a illumination array to an image.
//               
// arguments :   const ImageStruct * inputImage        -   the input image
//               ImageStruct * outputImage             -   the output image
//               const Image8Value *illuminationArray  -   the illumination array
// -----------------------------------------------------------------------------

void changeIllumination(const ImageStruct * inputImage, ImageStruct * outputImage, const Image8Value *illuminationArray)
{
    int i, j;

    for (j = 0; j < ImageYSize(outputImage); j++)
    {
        for (i = 0; i < ImageXSize(outputImage); i++)
        {
            SetImage8Pixel(outputImage, i, j, illuminationArray[Image8Pixel(inputImage, i, j)] );
        }
    }  
}
