#include "main.h"
#include "config.h"
#include "matrix.h"
#include "image_transform.h"

#include <iostream>
#include <fstream>
#include <sstream>

// loadConfiguration -----------------------------------------------------------
//
// description : this function loads the different parameters contained in the
//               input configuration file.
//               
// arguments :   char *config_name           -      name of the configuration file
// -----------------------------------------------------------------------------

using namespace std;

Config loadConfiguration(string config_name)
{
    Config config;
    string token;
    string sub_token;
    
    fstream config_file( config_name.data());
    
    if( config_file.bad()){
        return config;          
    }
     
    config.transformation_nb = 1;   // nb of trans to make on each image
    config.rotation.min = 0.0;            // rotation range
    config.rotation.max = 0.0;            // rotation range
    config.shiftX.min = 0.0;              // shiftX range
    config.shiftX.max = 0.0;              // shiftX range
    config.shiftY.min = 0.0;              // shiftY range
    config.shiftY.max = 0.0;              // shiftY range
    config.shearX.min = 0.0;              // shearX range
    config.shearX.max = 0.0;              // shearX range
    config.shearY.min = 0.0;              // shearY range
    config.shearY.max = 0.0;              // shearY range
    config.scale.min = 1.0;               // scale range
    config.scale.max = 1.0;               // scale range
    config.brightness.min = 0.0;          // brightness range
    config.brightness.max = 0.0;          // brightness range
    config.contrast.min = 1.0;            // contrast range
    config.contrast.max = 1.0;            // contrast range
    config.gamma.min = 1.0;               // gamma range
    config.gamma.max = 1.0;               // gamma range
    config.output_resolution.x = 32;   // resolution of output images
    config.output_resolution.y = 32;   // resolution of output images
    config.gaussianNoiseSTDDev = 0;
    
    
    
    // Parsing the configuration file detecting the tags and storing the values in the config structure
    while ( config_file.good())
    {
        string s;
        config_file >> token;    
        if ( token == "<transformation_nb>")
        {
            config_file >> s;
            config_file >> config.transformation_nb;
        }
        if ( token == "<shiftX_range>")
        {
            config_file >> s >> s;
            config_file >> config.shiftX.min;
            config_file >> s;
            config_file >> config.shiftX.max;
        }
        if ( token == "<shiftY_range>")
        {
            config_file >> s >> s;
            config_file >> config.shiftY.min;
            config_file >> s;
            config_file >> config.shiftY.max;
        }
        if ( token == "<scale_range>")
        {
            config_file >> s >> s;
            config_file >> config.scale.min;
            config_file >> s;
            config_file >> config.scale.max;
        }
        if ( token == "<shearX_range>")
        {
            config_file >> s >> s;
            config_file >> config.shearX.min;
            config_file >> s;
            config_file >> config.shearX.max;
        }
        if ( token == "<shearY_range>")
        {
            config_file >> s >> s;
            config_file >> config.shearY.min;
            config_file >> s;
            config_file >> config.shearY.max;
        }      
        if ( token == "<rotation_range>")
        {
            config_file >> s >> s;
            config_file >> config.rotation.min;
            config_file >> s;
            config_file >> config.rotation.max;
        }
        if ( token == "<brightness_range>")
        {
            config_file >> s >> s;
            config_file >> config.brightness.min;
            config_file >> s;
            config_file >> config.brightness.max;
        }
        if ( token == "<contrast_range>")
        {
            config_file >> s >> s;
            config_file >> config.contrast.min;
            config_file >> s;
            config_file >> config.contrast.max;
        }
        if ( token == "<gamma_range>")
        {
            config_file >> s >> s;
            config_file >> config.gamma.min;
            config_file >> s;
            config_file >> config.gamma.max;
        }
        if ( token == "<output_resolution>")
        {
            config_file >> s;
            config_file >> config.output_resolution.x;
            config_file >> s;
            config_file >> config.output_resolution.y;
        }
        if ( token == "<gaussian_noise>"){

            config_file >> s;//
            config_file >> config.gaussianNoiseSTDDev; 
        }
        
    } // end while
    
    config_file.close();
    
    config.configOK = true;
    return config;
}

static void split( string in, string &left, string &right){
    bool found = false;
    left = "";
    right = "";
    for( int i = 0; i < in.length(); i++){
        if( found){
            right.push_back( in[ i]);
        } else if( in[i] == ':'){
            found = true;
        } else {
            left.push_back( in[ i]);
        }
    }   
}

// loadAnnotation --------------------------------------------------------------
//
// description : this function loads the annotations of one image in the annotation 
//               file discribing a specific dataset.
//               This includes the coordinates of the 4 corners of every region 
//               of interest that is declared and to which sub class it belongs to.   
//               
// arguments :   char *annotation_name     -      name of the annotation file
//               char* image_name          -      name of the image
//               int &object_nb            -      number of objects (regions of interest)
// -----------------------------------------------------------------------------
bool check( string s){
    int i1 = 0;
    int i2 = 0;
    bool found = false;
    for( int i = 0; i < s.length(); i++){
        if( s[ i] >= '0' && s[ i] <= '9' && !found){
            i1++;   
        } else if( s[ i] >= '0' && s[ i] <= '9' && found){
            i2++;
        } else if( s[ i] == ':' && !found){
            found = true;
        } else {
            break;
        }
    }
    if( i1 == 0 || i2 == 0){
         return false;
    }
    return true;
}

void loadAnnotation( string annotationFileName, vector< TAnnotation> &annotations)
{
    annotations.clear();   
    
    // Opening the annotation file
    fstream annotation_file( annotationFileName.data());
    if ( !annotation_file.good()) {
        cerr << "Error: annotation file could not be opened. File name: " << annotationFileName << "." << endl;
        exit( 1);
    }

            
    // Parsing the annotation file detecting the tags and storing the values in the annotation structure
    while ( annotation_file.good())
    {
        string token;
        annotation_file >> token;
        
        if ( token == "<image>")
        {
            string imageName;
            annotation_file >> imageName;
            annotations.push_back( TAnnotation( imageName));
            
            for( ;  annotation_file.good() && token != "</image>"; annotation_file >> token)
            {   
                if ( token == "<object>")
                {

                    string sub_class;
                    string roi_LeftBottom;
                    string roi_LeftTop;
                    string roi_RightBottom;
                    string roi_RightTop;
                    string s;
                    
                    
                    for( ; annotation_file.good() && token != "</object>"; annotation_file >> token)
                    { 
                        if ( token == "sub_class")
                        {
                            annotation_file >> s;
                            annotation_file >> sub_class;
                        }
                        if ( token == "roi_LeftBottom")
                        {
                            annotation_file >> s;
                            annotation_file >> roi_LeftBottom;
                        }
                        if ( token == "roi_LeftTop")
                        {
                            annotation_file >> s;
                            annotation_file >> roi_LeftTop;
                        }
                        if ( token == "roi_RightBottom")
                        {
                            annotation_file >> s;
                            annotation_file >> roi_RightBottom;
                        }
                        if ( token == "roi_RightTop")
                        {
                            annotation_file >> s;
                            annotation_file >> roi_RightTop;
                        }
                    }
                    
                    check( roi_LeftBottom );
                    check( roi_LeftTop);
                    check( roi_RightBottom);
                    check( roi_RightTop);
                    
                    TObject object;
                    
                    object.sub_class = sub_class;
                    
                    
                    string left, right;
                    split( roi_LeftBottom, left, right);
                    object.roi_LeftBottom = Coordinates( atoi( left.data()), atoi( right.data()));
                    
                    split( roi_LeftTop, left, right);
                    object.roi_LeftTop = Coordinates( atoi( left.data()), atoi( right.data()));

                    split( roi_RightBottom, left, right);
                    object.roi_RightBottom = Coordinates( atoi( left.data()), atoi( right.data()));

                    split( roi_RightTop, left, right);     
                    object.roi_RightTop = Coordinates( atoi( left.data()), atoi( right.data()));
                    
                    
                    annotations.back().objects.push_back( object);
                    
                }
            }
        }
    }

    annotation_file.close();

}

