//---------------------------------------------------------------------------


#include <assert.h>
#include <stdlib.h>
#include <mem.h>
#include "Tools.h"
//image.h


#define MIN( x, y) ( ((x) < (y))?(x):(y) )
#define MAX( x, y) ( ((x) > (y))?(x):(y) )

Image8Value RGBToGrayA(ImageRGBValueRGB v) {
   return (((v & 0xFF) * 144) +
   (((v & 0xFF00) >> 8) * 587) +
   (((v & 0xFF0000) >> 16) * 227)) / 1000;
}

/*
   Calculate HSL from RGB
   Hue is 0 .. 255
*/              
void RGBtoHImage8( ImageStruct * src, ImageStruct * dest){
    int sizeX = src->XSize;
    if( dest->XSize < sizeX){
        sizeX = dest->XSize;
    }

    int sizeY = src->YSize;
    if( dest->YSize < sizeY){
        sizeY = dest->YSize;
    }

    for( int y = 0; y < sizeY; y++){

        unsigned long * source = &ImageRGBLinearPixelRGB( src, 0, y);
        unsigned char * destination = &Image8LinearPixel( dest, 0, y);

        for( source; source <= &ImageRGBLinearPixelRGB( src, sizeX - 1, y); source++){

            float themin, themax, delta, l, s;
            float r = ((*(source) & 0xFF0000) >> 16) / 256.0;
            float g = ((*(source) & 0xFF00) >> 8) / 256.0;
            float b = (*(source) & 0xFF) / 256.0;

            themin = MIN( r, MIN( g, b));
            themax = MAX( r, MAX( g, b));
            delta = themax - themin;

            l = (themin + themax) / 2;

            s = 0;
            if ( l > 0 && l < 1)
                s = delta / ( l < 0.5 ? (2 * l) : (2 - 2 * l));

            float h = 0;
            if (delta > 0) {
                if( themax == r && themax != g)
                     h += ( g - b) / delta;
                if( themax == g && themax != b)
                     h += ( 2 + ( b - r) / delta);
                if( themax == b && themax != r)
                     h += ( 4 + ( r - g) / delta);
                h *= 60;
            }


            if( s > 0.1 && l > 0.1 ){
                *( destination++ ) =  (int)( (h * 256.0 ) / 360.0);
            } else {
                *( destination++ ) = 0;
            }

        }
    }
}

void NormRGB( ImageStruct * src){
    int sizeX = src->XSize;

    int sizeY = src->YSize;

    for( int y = 0; y < sizeY; y++){
        unsigned long * source = &ImageRGBLinearPixelRGB( src, 0, y);
        for( source; source <= &ImageRGBLinearPixelRGB( src, sizeX - 1, y); source++){

            register int sum = (*source & 0xFF) + ((*source & 0xFF00) >> 8) + ((*source & 0xFF0000) >> 16);

            if( sum > 50){
                *(source) = ((((( (*source) & 0xFF0000)) << 8) / sum) & 0xFF0000)
                          | ((((( (*source) & 0xFF00)) << 8) / sum) & 0xFF00)
                          | ((((( (*source) & 0xFF)) << 8) / sum) & 0xFF);
            } else {
                *(source) = 0;
            }
        }
    }
}

void RGBtoNormR(ImageStruct * src, ImageStruct * dest){
    int sizeX = src->XSize;
    if( dest->XSize < sizeX){
        sizeX = dest->XSize;
    }

    int sizeY = src->YSize;
    if( dest->YSize < sizeY){
        sizeY = dest->YSize;
    }

    for( int y = 0; y < sizeY; y++){
        unsigned long * source = &ImageRGBLinearPixelRGB( src, 0, y);
        unsigned char * destination = &Image8LinearPixel( dest, 0, y);
        for( source; source <= &ImageRGBLinearPixelRGB( src, sizeX - 1, y); source++){

            register int sum = (*source & 0xFF) + ((*source & 0xFF00) >> 8) + ((*source & 0xFF0000) >> 16);

            if( sum > 0){
                *(destination++) = ((((*source) & 0xFF0000) >> 16) * 256) / sum;
            } else {
                *(destination++) = 0;
            }

        }
    }
}

void RGBtoNormG(ImageStruct * src, ImageStruct * dest){
    int sizeX = src->XSize;
    if( dest->XSize < sizeX){
        sizeX = dest->XSize;
    }

    int sizeY = src->YSize;
    if( dest->YSize < sizeY){
        sizeY = dest->YSize;
    }

    for( int y = 0; y < sizeY; y++){
        unsigned long * source = &ImageRGBLinearPixelRGB( src, 0, y);
        unsigned char * destination = &Image8LinearPixel( dest, 0, y);
        for( source; source <= &ImageRGBLinearPixelRGB( src, sizeX - 1, y); source++){

            register int sum = (*source & 0xFF) + ((*source & 0xFF00) >> 8) + ((*source & 0xFF0000) >> 16);
            
            if( sum > 0){
                *(destination++) = ((((*source) & 0xFF00) >> 8) * 256) / sum;
            } else {
                *(destination++) = 0;
            }

        }
    }
}


void RGBtoNormB(ImageStruct * src, ImageStruct * dest){
    int sizeX = src->XSize;
    if( dest->XSize < sizeX){
        sizeX = dest->XSize;
    }

    int sizeY = src->YSize;
    if( dest->YSize < sizeY){
        sizeY = dest->YSize;
    }

    for( int y = 0; y < sizeY; y++){
        unsigned long * source = &ImageRGBLinearPixelRGB( src, 0, y);
        unsigned char * destination = &Image8LinearPixel( dest, 0, y);
        for( source; source <= &ImageRGBLinearPixelRGB( src, sizeX - 1, y); source++){

            register int sum = (*source & 0xFF) + ((*source & 0xFF00) >> 8) + ((*source & 0xFF0000) >> 16);
            
            if( sum > 0){
                *(destination++) = (((*source) & 0xFF) * 256) / sum;
            } else {
                *(destination++) = 0;
            }

        }
    }
}




static void copyBoarderImage8( ImageStruct * src, ImageStruct * dest, int sizeX, int sizeY,
        int boarderWidth, int boarderHeight)
{
    for( int y = 0; y < boarderHeight; y++)
        for( int x = 0; x < sizeX; x++)
            SetImage8LinearPixel( dest, x, y, Image8LinearPixel( src, x, y));

    for( int y = sizeY - boarderHeight; y < sizeY; y++)
        for( int x = 0; x < sizeX; x++)
            SetImage8LinearPixel( dest, x, y, Image8LinearPixel( src, x, y));

    for( int y = 0; y < sizeY; y++)
        for( int x = 0; x < boarderWidth; x++)
            SetImage8LinearPixel( dest, x, y, Image8LinearPixel( src, x, y));

    for( int y = 0; y < sizeY; y++)
        for( int x = sizeX - boarderWidth; x < sizeX; x++)
            SetImage8LinearPixel( dest, x, y, Image8LinearPixel( src, x, y));
}

static void copyBoarderImage32( ImageStruct * src, ImageStruct * dest, int sizeX, int sizeY,
        int boarderWidth, int boarderHeight)
{
    for( int y = 0; y < boarderHeight; y++)
        for( int x = 0; x < sizeX; x++)
            SetImage32LinearPixel( dest, x, y, Image32LinearPixel( src, x, y));

    for( int y = sizeY - boarderHeight; y < sizeY; y++)
        for( int x = 0; x < sizeX; x++)
            SetImage32LinearPixel( dest, x, y, Image32LinearPixel( src, x, y));

    for( int y = 0; y < sizeY; y++)
        for( int x = 0; x < boarderWidth; x++)
            SetImage32LinearPixel( dest, x, y, Image32LinearPixel( src, x, y));

    for( int y = 0; y < sizeY; y++)
        for( int x = sizeX - boarderWidth; x < sizeX; x++)
            SetImage32LinearPixel( dest, x, y, Image32LinearPixel( src, x, y));
}



void FilterConvImage8( ImageStruct * src, ImageStruct * dest, int * mask, int maskWidth, int maskHeight, int scale){
    int sizeX = src->XSize;
    if( dest->XSize < sizeX){
        sizeX = dest->XSize;
    }

    int sizeY = src->YSize;
    if( dest->YSize < sizeY){
        sizeY = dest->YSize;
    }
    int displacementX = maskWidth / 2;
    int displacementY = maskHeight / 2;

    assert( ImageYOffset( src) < 0);

    for( int y = displacementY; y < sizeY - displacementY; y++){
        for( int x = displacementX ; x < sizeX - displacementX; x++){
            int avrg = 0;
            int maskPos = 0;
            for( int yy = - displacementY; yy <= displacementY; yy++){
                for( int xx = -displacementX; xx <= displacementX; xx++){
                    avrg += Image8LinearPixel( src, x + xx, y + yy) * mask[ maskPos++];
                }
            }
 
            SetImage8LinearPixel( dest, x, y, avrg / scale);

        }
    }
    copyBoarderImage8( src, dest, sizeX, sizeY, displacementX, displacementY);

}

void RGBToIntensity( ImageStruct * src, ImageStruct * dest){
    int sizeX = src->XSize;
    if( dest->XSize < sizeX){
        sizeX = dest->XSize;
    }

    int sizeY = src->YSize;
    if( dest->YSize < sizeY){
        sizeY = dest->YSize;
    }

    for( int y = 0; y < sizeY; y++){
        unsigned long * source = &ImageRGBLinearPixelRGB( src, 0, y);
        unsigned char * destination = &Image8LinearPixel( dest, 0, y);
        for( source; source <= &ImageRGBLinearPixelRGB( src, sizeX - 1, y); source++){

            *(destination++) =
                 (((*source & 0xFF) * 144) +
                 ((*source & 0xFF00) >> 8) * 587 +
                 ((*source & 0xFF0000) >> 16) * 227)
                  / 1000;
        }
    }
}
void MullImage32( ImageStruct * src, float scale){
    int sizeX = src->XSize;
    int sizeY = src->YSize;

    for( int y = 0; y < sizeY; y++){
        long * source = &Image32LinearPixel( src, 0, y);
        for( source; source <= &Image32LinearPixel( src, sizeX - 1, y); source++){
            *(source) = (long)(*(source) * scale);
        }
    }
}

void AddImage32( ImageStruct * src, int number){
    int sizeX = src->XSize;
    int sizeY = src->YSize;

    for( int y = 0; y < sizeY; y++){
        long * source = &Image32LinearPixel( src, 0, y);
        for( source; source <= &Image32LinearPixel( src, sizeX - 1, y); source++){
            *(source) += number;
        }
    }
}

void AddImage8Image32( ImageStruct * src, ImageStruct * dest){
    int sizeX = src->XSize;
    if( dest->XSize < sizeX){
        sizeX = dest->XSize;
    }

    int sizeY = src->YSize;
    if( dest->YSize < sizeY){
        sizeY = dest->YSize;
    }

    for( int y = 0; y < sizeY; y++){
        unsigned char *source = &Image8LinearPixel( src, 0, y);
        long * destination = &Image32LinearPixel( dest, 0, y);
        for( source; source <= &Image8LinearPixel( src, sizeX - 1, y); source++){
            *(destination++) += *(source);
        }
    }
}
void SubstrImage8Image32( ImageStruct * src, ImageStruct * dest){
    int sizeX = src->XSize;
    if( dest->XSize < sizeX){
        sizeX = dest->XSize;
    }

    int sizeY = src->YSize;
    if( dest->YSize < sizeY){
        sizeY = dest->YSize;
    }

    for( int y = 0; y < sizeY; y++){
        unsigned char *source = &Image8LinearPixel( src, 0, y);
        long * destination = &Image32LinearPixel( dest, 0, y);
        for( source; source <= &Image8LinearPixel( src, sizeX - 1, y); source++){
            *(destination++) -= *(source);
        }
    }
}

void SubstrImage32Image32( ImageStruct * src, ImageStruct * dest){
    int sizeX = src->XSize;
    if( dest->XSize < sizeX){
        sizeX = dest->XSize;
    }

    int sizeY = src->YSize;
    if( dest->YSize < sizeY){
        sizeY = dest->YSize;
    }

    for( int y = 0; y < sizeY; y++){
        long *source = &Image32LinearPixel( src, 0, y);
        long * destination = &Image32LinearPixel( dest, 0, y);
        for( source; source <= &Image32LinearPixel( src, sizeX - 1, y); source++){
            *(destination++) -= *(source);
        }
    }
}

void SubstrImage32Image32Image32( ImageStruct * src, ImageStruct * src2, ImageStruct * dest){
    int sizeX = src->XSize;
    if( dest->XSize < sizeX){
        sizeX = dest->XSize;
    }
    if( src2->XSize < sizeX){
        sizeX = src2->XSize;
    }

    int sizeY = src->YSize;
    if( dest->YSize < sizeY){
        sizeY = dest->YSize;
    }
    if( src2->YSize < sizeY){
        sizeY = src2->YSize;
    }

    for( int y = 0; y < sizeY; y++){
        long *source1 = &Image32LinearPixel( src, 0, y);
        long *source2 = &Image32LinearPixel( src2, 0, y);

        long * destination = &Image32LinearPixel( dest, 0, y);
        for( source1; source1 <= &Image32LinearPixel( src, sizeX - 1, y);source1 ++){
            *(destination++) = *(source1) - *(source2++) ;
        }
    }
}

void Image32to8( ImageStruct * src, ImageStruct * dest, int scale){
    int sizeX = src->XSize;
    if( dest->XSize < sizeX){
        sizeX = dest->XSize;
    }

    int sizeY = src->YSize;
    if( dest->YSize < sizeY){
        sizeY = dest->YSize;
    }

    for( int y = 0; y < sizeY; y++){
        long * source = &Image32LinearPixel( src, 0, y);
        unsigned char * destination = &Image8LinearPixel( dest, 0, y);
        for( source; source <= &Image32LinearPixel( src, sizeX - 1, y); source++){
            *(destination++) = *(source) / scale;
        }
    }
}

void Image8to32( ImageStruct * src, ImageStruct * dest){
    int sizeX = src->XSize;
    if( dest->XSize < sizeX){
        sizeX = dest->XSize;
    }

    int sizeY = src->YSize;
    if( dest->YSize < sizeY){
        sizeY = dest->YSize;
    }

    for( int y = 0; y < sizeY; y++){
        unsigned char * source = &Image8LinearPixel( src, 0, y);
        long * destination = &Image32LinearPixel( dest, 0, y);
        for( source; source <= &Image8LinearPixel( src, sizeX - 1, y); source++){
            *(destination++) = *(source) ;
        }
    }
}

void FilterAvrgImage8( ImageStruct * src, ImageStruct * dest, int maskWidth){
    int sizeX = src->XSize;
    if( dest->XSize < sizeX){
        sizeX = dest->XSize;
    }

    int sizeY = src->YSize;
    if( dest->YSize < sizeY){
        sizeY = dest->YSize;
    }
    int displacement = maskWidth / 2;

    for( int y = displacement; y < sizeY - displacement; y++){

        int avrg = 0;
        for( int yy = -displacement; yy <= displacement; yy++){    //vypocitame soucet pixelu v okne na zacatku radku
            for( int xx = -displacement; xx <= displacement; xx++){
                avrg += Image8LinearPixel( src, displacement + xx, y + yy);
            }
        }

        SetImage8LinearPixel( dest, displacement, y, avrg / maskWidth / maskWidth);

        assert( ImageYOffset( src) < 0);

        for( int x = displacement + 1 ; x < sizeX - displacement; x++){
            unsigned char * source = &Image8Pixel( src, x, y - displacement);

            //ImageYOffset je zaporny, proto je ta podminka divna
            for( ;source >= &Image8LinearPixel( src, x, y + displacement); source += ImageYOffset( src)){
                avrg +=  *(source + displacement) - *(source - displacement - 1) ;
            }

            SetImage8LinearPixel( dest, x, y, avrg / maskWidth / maskWidth);
        }
    }
    copyBoarderImage8( src, dest, sizeX, sizeY, displacement, displacement);
}

void ImageCopyRGB(ImageStruct * src, ImageStruct * dest) {
  if (src->XSize != dest->XSize) return;
  if (src->YSize != dest->YSize) return;
  for (int y = 0; y < src->YSize; y++)
    for (int x = 0; x < src->XSize; x++) {
      SetImageRGBLinearPixelRGB(dest, x, y, ImageRGBLinearPixelRGB(src, x, y));
    }
}

void ImageCopy8(ImageStruct * src, ImageStruct * dest) {
  assert(src->XSize == dest->XSize && src->YSize == dest->YSize);
  for (int y = 0; y < src->YSize; y++)
    for (int x = 0; x < src->XSize; x++) {
      SetImage8LinearPixel(dest, x, y, Image8LinearPixel(src, x, y));
    }
}

void SobelImage32( ImageStruct * src, ImageStruct * dest){
    int sizeX = src->XSize;
    if( dest->XSize < sizeX){
        sizeX = dest->XSize;
    }

    int sizeY = src->YSize;
    if( dest->YSize < sizeY){
        sizeY = dest->YSize;
    }

    for( int y = 1; y < sizeY - 1; y++){
        for( int x = 1 ; x < sizeX - 1; x++){
//            long * source =  &Image32LinearPixel( src, x, y);

            long dy;
            dy = Image32LinearPixel( src, x - 1, y - 1);
            dy += 2 * Image32LinearPixel( src, x, y - 1);
            dy += Image32LinearPixel( src, x + 1, y -1);

            dy -= Image32LinearPixel( src, x - 1, y + 1);
            dy -= 2 * Image32LinearPixel( src, x, y + 1);
            dy -= Image32LinearPixel( src, x + 1, y + 1);

            long dx;
            dx = Image32LinearPixel( src, x - 1, y - 1);
            dx += 2 * Image32LinearPixel( src, x - 1, y);
            dx += Image32LinearPixel( src, x - 1, y + 1);

            dx -= Image32LinearPixel( src, x + 1, y - 1);
            dx -= 2 * Image32LinearPixel( src, x + 1, y);
            dx -= Image32LinearPixel( src, x + 1, y + 1);

            int color = (abs(dx) + abs(dy)) / 2;
            if( color > 255)
                color = 255;

            SetImage32LinearPixel( dest, x, y, color);
        }
    }
    copyBoarderImage32( src, dest, sizeX, sizeY, 1, 1);
}

void MedianImage8(ImageStruct * img)
{
  int mask = 3;
  // Vypocet stredove hodnoty podle velikosti masky
  //int med = (((0 * mask + 1) * (mask)) + (mask*1)) << 8;
  int med = 8 << 8;

  // !!!!
  ImageStruct * medtmp = NewImage8(img->XSize, img->YSize);

  for(int y = 0; y < img->YSize; y++)
    for(int x = 0; x < img->XSize; x++)
    {
      SetImage8LinearPixel(medtmp, x, y, 0);
    }

    for(int y = mask; y < img->YSize - mask; y++)
    {
      for(int x = mask ; x < img->XSize - mask; x++)
      {
        int p = 0;
        for(int n = -mask; n <= mask; n++)
        {
          for(int m = -mask; m <= mask; m++)
          {
            p += Image8LinearPixel(img, x+m, y+n);
          }
        } // for n
        SetImage8LinearPixel(medtmp, x, y, (p > med) ? 255 : 0);
      } // for x
    } // for y
    ImageCopy8(medtmp, img);
    DeleteImage(medtmp);
}

//---------------------------------------------------------------------------

