#ifdef __BORLANDC__
#undef __USELOCALES__
#pragma package(smart_init)
#endif

#ifdef __BORLANDC__
 #pragma hdrstop
#endif

#include "GraLi.h"
#include "Image.h"
#include "ImageInt.h"

#include <iostream>

void InterpolateImage(ImageStruct * Result,const ImageStruct * Image, const PointStruct * LeftTop, const PointStruct * RightTop, const PointStruct * LeftBottom, const PointStruct * RightBottom)
{

  int i;
  int j;
  int XSize = ImageXSize(Result);
  int YSize = ImageYSize(Result);
  float XCoef = XSize-1;
  float YCoef = YSize-1;

  if (((ImagePixelType(Image)&~ImageLinearMask)==Image8)&&((ImagePixelType(Result)&~ImageLinearMask)==Image8))
  {
    for (i = 0; i< XSize; ++i) 
        for ( j = 0; j < YSize; ++j)
    {
      float X = (XCoef-i)/XCoef*(YCoef-j)/YCoef*LeftTop->X+i/XCoef*(YCoef-j)/YCoef*RightTop->X+(XCoef-i)/XCoef*j/YCoef*LeftBottom->X+i/XCoef*j/YCoef*RightBottom->X;
      float Y = (XCoef-i)/XCoef*(YCoef-j)/YCoef*LeftTop->Y+i/XCoef*(YCoef-j)/YCoef*RightTop->Y+(XCoef-i)/XCoef*j/YCoef*LeftBottom->Y+i/XCoef*j/YCoef*RightBottom->Y;

      float Pixel;

      if ( (X < 0)||( int(X) + 1 >= Image->XSize)||(Y<0)||( int(Y) + 1 >= Image->YSize))
      {
        Pixel = 0;
      }
      else
      {
        Pixel = (X-(int)X)*(Y-(int)Y)*Image8Pixel(Image,(int)X+1,(int)Y+1)
               +(1-(X-(int)X))*(Y-(int)Y)*Image8Pixel(Image,(int)X,(int)Y+1)
               +(X-(int)X)*(1-(Y-(int)Y))*Image8Pixel(Image,(int)X+1,(int)Y)
               +(1-(X-(int)X))*(1-(Y-(int)Y))*Image8Pixel(Image,(int)X,(int)Y);
      }
      SetImage8Pixel( Result, i, j, (Image8Value) Pixel);
    }
  }
}
