/****************************************************************************/
/*                                                                          */
/*                                                                          */
/*               ColorDef.h - Color Definitions (c) 1998 PEZIK              */
/*                                                                          */
/*                                                                          */
/****************************************************************************/

#ifndef _COLORDEF
#define _COLORDEF


typedef unsigned long ColorType;
#define BlackColor   0x000000UL
#define RedColor     0x0000FFUL
#define GreenColor   0x00FF00UL
#define BlueColor    0xFF0000UL
#define WhiteColor   0xFFFFFFUL
#define YellowColor  0x00FFFFUL
#define MagentaColor 0xFF00FFUL
#define CyanColor    0xFFFF00UL
#define GrayColor    0x808080UL

#define RGBToGrayRGB(R,G,B) ((3*(R)+7*(G)+1*(B))/10)
#define RGBToGray(Color) RGBToGrayRGB(((Color)&0x0000FF),((Color)&0x00FF00)>>8,((Color)&0xFF0000)>>16)
#define GrayToRGB(Gray) (0x1001001*(Gray))

typedef int PointShape;
#define CrossPoint 0
#define DotPoint 1
#define RoundPoint 2
#define NoPoint -1

typedef int FontType;
#define NormalFont 0
#define ArialFont 1
#define CourierFont 2
#define LargeFont 4
#define ExtraLargeFont 8
#define BoldFont 16
#define ItalicsFont 32
#define UnderlinedFont 64

#endif
