#ifndef _COMMON_H_
#define _COMMON_H_
// common.h
// General useful functions

#include <sstream>
#include "../Support/SimpleXML.h"

class TObject{
public:
    virtual bool OK() = 0;
    
    virtual void storeToXML( TXMLOutput *) = 0;
};

extern unsigned randomGeneratorState;

/// Convert string to any type.
/// Optionally checks if whole string was converted.
/// When no string given (str==0) default value for _T is assigned output variable. 
/// @param str String to convert
/// @param value Destination for converted value
/// @param check Check leftover characters flag (default true)
/// @param f Base for conversion (default std::dec)
/// \returns Flag signalizing successful conversion
template <class _T>
bool strConvert(const char * str, _T & value, bool check = true, std::ios_base & (*f)(std::ios_base&) = std::dec)
{
	if (!str)
	{
		value = _T();
		return false;
	}
	std::istringstream iss(str);
	char c;
	//!(!(iss >> f >> value) || (check && iss.get(c)));
	return (iss >> f >> value) && !(check && iss.get(c));
}


/// Sets RNG seed.
inline void randomSeed( const unsigned seed)
{
    randomGeneratorState = seed;
}

/// Random number generator.
inline unsigned random()
{
    return randomGeneratorState = 1664525 * randomGeneratorState + 1013904223;
}


#endif
