#include "Log.h"

#include <iostream>
#include <fstream>
#include <string>
#include <ctime>
#include <sstream>
#include <cassert>
#include <sstream>

using namespace std;

static string logDirectory = "";
static string dataDirectory = "./";

static time_t startTime;

#ifdef WIN32
  const string GNUPLOT = "pgnuplot ";
#else 
  const string GNUPLOT = "gnuplot ";
#endif

std::string currentTimeDate( void)
{
  time_t rawtime;
  time( &rawtime);
  return ctime( &rawtime);
}

std::string elapsedTime( void)
{
    time_t rawTime;
    time( &rawTime);

    double difference = difftime( rawTime, startTime);
    int hours = int (difference / 3600);
    difference = difference - (hours * 3600.0);
    int minutes = int (difference / 60);
    difference = difference - (minutes * 60.0);
    int seconds = int (difference);

    stringstream str;
    str << hours << ':' << minutes << ':' << seconds;

    return str.str();
}

static string changeSlashes( string &str){
    string out( str);
    for( unsigned i = 0; i < out.size(); i++){  
        if( out[i] == '/'){
            out[i] = '\\';
        }
    }

    return out;
}

static void redirectLog( std::string logFileName)
{
    // change \ to / in the logFileName
    for( unsigned i = 0; i < logFileName.size(); i++){  
        if( logFileName[i] == '\\'){
            logFileName[i] = '/';
        }
    }

    // get the positions of last dot and last slash
    string::size_type dotPos = logFileName.rfind( '.'); 
    string::size_type slashPos = logFileName.rfind( '/'); 

    if( slashPos == string::npos){
        slashPos = 0;
    } else {
        slashPos++;
    }
    if( dotPos < slashPos){
        dotPos = string::npos;
    }
    
    // extract the directories
    logDirectory = logFileName.substr( 0, slashPos);
    dataDirectory = "./" + logFileName.substr( slashPos, dotPos - slashPos) + "/";
    
    string s = "mkdir " + logDirectory + dataDirectory;
    // create the log and data directory
    system( changeSlashes( s).data());

    // redirect cout to the new file
    ofstream *file = new ofstream( logFileName.data(), ios::trunc);

    if( !file->good()){
        cerr << "Error: Unable to open log file \"" << logFileName << "\"." << endl;
        exit( -1);
    }
    cout.rdbuf( file->rdbuf());
}

std::string getDataDirectory( )
{
    return dataDirectory;
}

std::string getLogDirectory( )
{
    return logDirectory;
}

// prepare the HTML output
void startLog( std::string logFileName)
{
    if( !logFileName.empty()){
        redirectLog( logFileName);
    }
    startTime = time( NULL);

    cout << "<html>" << endl;
    cout << "<head>" << endl;
    cout << "   <title>Boosting experiment log.</title> " << endl;
    cout << "</head>" << endl;
    cout << "<body text=\"black\" bgcolor=\"white\"  link=\"blue\" vlink=\"darkgreen\"> " << endl;
    cout << "<pre>" << endl;
    cout << "#  Current day and time: " << currentTimeDate();
}

// finish the HTML output
void endLog( void)
{
    cout << "#  Current day and time: " << currentTimeDate() << endl << endl;
    cout << "#  Running time: " << elapsedTime() << endl;
    cout << "</pre>" << endl;
    cout << "</body>" << endl;
    cout << "</html>" << endl;
}

static unsigned unnamedPlotCount = 0;

string plotToLog( std::vector< double> &valuesY, std::string variableName, std::string plotName, std::string plotProp, std::string lineProp)
{

    string plotFileName = plotName;

    if( plotFileName.empty()){
        stringstream str;
        str << "plot_" << num2str( ++unnamedPlotCount, 5);
        plotFileName = str.str();
    }

    ofstream dataFile( (logDirectory + dataDirectory + plotFileName + ".txt").data(), ios_base::trunc);
    
    if( dataFile.fail()){
        cerr << "Error: Unable to open temporary data file \"" << logDirectory + dataDirectory + plotFileName + ".txt" << "\"." << endl;
        return "";
    }

    for( unsigned i = 0; i < valuesY.size(); i++) {
        dataFile << valuesY[i] << endl;
    }

    if( dataFile.fail()){
        cerr << "Error: Unable to write to temporary data file \"" << logDirectory + dataDirectory + plotFileName + ".txt" << "\"." << endl;
        return "";
    }

    ofstream plotScr( (logDirectory + dataDirectory + "GNUPlotScript.txt").data(), ios_base::trunc);

    if( plotScr.fail()){
        cerr << "Error: Unable to open temporary GNUPlot script file \"" << logDirectory + dataDirectory + "GNUPlotScript.txt" << "\"." << endl;
        return "";
    }

    plotScr << "set terminal png" << endl;
    plotScr << "set output \"" << logDirectory + dataDirectory + plotFileName << ".png\"" << endl;
    plotScr << "set grid" << endl;
    plotScr << "set title \"" << plotName<< "\"" << endl;
    plotScr << plotProp << endl;
    plotScr << "plot \"" << logDirectory + dataDirectory << plotFileName + ".txt\" smooth unique ";
    if( !variableName.empty()){
        plotScr << " title \"" << variableName << "\"";
    } else {
        plotScr << " notitle \"";
    }
    plotScr << lineProp << endl;

    if( plotScr.fail()){
        cerr << "Error: Unable to write to temporary GNUPlot script file \"" << logDirectory + dataDirectory + "GNUPlotScript.txt" << "\"." << endl;
        return "";
    }

    string s = GNUPLOT + logDirectory + dataDirectory + "GNUPlotScript.txt";
    system( changeSlashes(s).data());

    return dataDirectory + plotFileName + ".png"; 
}

string plotToLog( std::vector< double> &valuesX, std::vector< double> &valuesY, std::string variableName, std::string plotName, std::string plotProp, std::string lineProp)
{
    string plotFileName = plotName;

    if( plotFileName.empty()){
        stringstream str;
        str << "plot_" << num2str( ++unnamedPlotCount, 5);
        plotFileName = str.str();
    }

    ofstream dataFile( (logDirectory + dataDirectory + plotFileName + ".txt").data(), ios_base::trunc);
    
    if( dataFile.fail()){
        cerr << "Error: Unable to open temporary data file \"" << logDirectory + dataDirectory + plotFileName + ".txt" << "\"." << endl;
        return "";
    }

    if( valuesY.size() != valuesX.size()){
        cerr << "Warning: Data dimensions x and y do not match. Aborting current plot \"" << plotName << "\". " << endl;
        return "";
    }

    for( unsigned i = 0; i < valuesY.size(); i++) {
        dataFile << valuesX[ i] << "\t" << valuesY[ i] << endl;
    }

    if( dataFile.fail()){
        cerr << "Error: Unable to write to temporary data file \"" << logDirectory + dataDirectory + plotFileName + ".txt" << "\"." << endl;
        return "";
    }

    ofstream plotScr( (logDirectory + dataDirectory + "GNUPlotScript.txt").data(), ios_base::trunc);

    if( plotScr.fail()){
        cerr << "Error: Unable to open temporary GNUPlot script file \"" << logDirectory + dataDirectory + "GNUPlotScript.txt" << "\"." << endl;
        return "";
    }

    plotScr << "set terminal png" << endl;
    plotScr << "set output \"" << logDirectory + dataDirectory + plotFileName << ".png\"" << endl;
    plotScr << "set grid" << endl;
    plotScr << "set title \"" << plotName<< "\"" << endl;
    plotScr << plotProp << endl;
    plotScr << "plot \"" << logDirectory + dataDirectory << plotFileName + ".txt\" smooth unique ";
    if( !variableName.empty()){
        plotScr << " title \"" << variableName << "\"";
    } else {
        plotScr << " notitle \"";
    }
    plotScr << lineProp << endl;

    if( plotScr.fail()){
        cerr << "Error: Unable to write to temporary GNUPlot script file \"" << logDirectory + dataDirectory + "GNUPlotScript.txt" << "\"." << endl;
        return "";
    }

    string s = GNUPLOT + logDirectory + dataDirectory + "GNUPlotScript.png";
    system( changeSlashes(s).data());

    return dataDirectory + plotFileName + ".png"; 
}

string plotToLog( std::vector< std::vector<double> > &valuesY, std::vector< std::string> variableNames, std::string plotName, std::string plotProp, vector< std::string> lineProp)
{
    // check input
    assert( !(valuesY.empty() || valuesY.size() != variableNames.size() || !lineProp.empty() && lineProp.size() != valuesY.size()));

    string plotFileName = plotName;

    if( plotFileName.empty()){
        stringstream str;
        str << "plot_" << num2str( ++unnamedPlotCount, 5);
        plotFileName = str.str();
    }

    ofstream dataFile( (logDirectory + dataDirectory + plotFileName + ".txt").data(), ios_base::trunc);

    if( dataFile.fail()){
        cerr << "Error: Unable to open temporary data file \"" << logDirectory + dataDirectory + plotFileName + ".txt" << "\"." << endl;
        return "";
    }

    unsigned longestLine = 0;
    for( unsigned i = 0; i < valuesY.size(); i++){
        longestLine = max( (unsigned) valuesY[i].size(), longestLine);
    }

    for( unsigned i = 0; i < longestLine; i++){
        for( unsigned line = 0; line < valuesY.size(); line++) {
            if( valuesY[ line].size() > i){
                dataFile << valuesY[ line][i] << ' ';   
            } else {
                dataFile << valuesY[ line].back() << ' ';   
            }
        }
        dataFile << endl;
    }

    if( dataFile.fail()){
        cerr << "Error: Unable to write to temporary data file \"" << logDirectory + dataDirectory + plotFileName + ".txt" << "\"." << endl;
        return "";
    }

    dataFile.close();

    ofstream plotScr( (logDirectory + dataDirectory + "GNUPlotScript.txt").data(), ios_base::trunc);

    if( plotScr.fail()){
        cerr << "Error: Unable to open temporary GNUPlot script file \"" << logDirectory + dataDirectory + "GNUPlotScript.txt" << "\"." << endl;
        return "";
    }

    // prepare the plot
    plotScr << "set terminal png" << endl;
    plotScr << "set output \"" << logDirectory + dataDirectory + plotFileName << ".png\"" << endl;
    plotScr << "set grid" << endl;
    plotScr << "set title \"" << plotName<< "\"" << endl;
    plotScr << plotProp << endl;

    // plot the values
    plotScr << "plot ";
    for( unsigned i = 0; i < valuesY.size(); i++){
        plotScr << "\"" << logDirectory + dataDirectory << plotFileName + ".txt\" using " << i + 1 << " title \"" << variableNames[i] << "\"";
        if( lineProp.size() > i){
            plotScr << ' ' << lineProp[i];
        }
        if( i == valuesY.size() - 1){
            plotScr << " with lines ";
        } else {
            plotScr << " with lines, ";
        }
    }

    plotScr << endl;

    if( plotScr.fail()){
        cerr << "Error: Unable to write to temporary GNUPlot script file \"" << logDirectory + dataDirectory + "GNUPlotScript.txt" << "\"." << endl;
        return "";
    }
    plotScr.close();

    string s = GNUPLOT + logDirectory + dataDirectory + "GNUPlotScript.txt";
    system( changeSlashes(s).data());

     return dataDirectory + plotFileName + ".png"; 
}
string plotToLog( std::vector< std::vector<double> > &valuesX, std::vector< std::vector<double> > &valuesY, std::vector< std::string> &variableNames, std::string plotName, std::string plotProp, std::vector< std::string> lineProp)
{
    // check input
    assert( !(valuesY.empty() || valuesX.empty()|| valuesX.size() != valuesY.size() || valuesY.size() != variableNames.size() || !lineProp.empty() && lineProp.size() != valuesY.size()));

    unsigned longestLine = 0;
    for( unsigned i = 0; i < valuesY.size(); i++){
        assert( valuesY[i].size() == valuesX[i].size());
        if( valuesY[i].size() != valuesX[i].size()){
            cerr << "Warning: Data dimensions x and y do not match. Aborting current plot \"" << plotName << "\". " << endl;
            return "";
        }
        longestLine = max( (unsigned) valuesY[i].size(), longestLine);
    }

    string plotFileName = plotName;

    if( plotFileName.empty()){
        stringstream str;
        str << "plot_" << num2str( ++unnamedPlotCount, 5);
        plotFileName = str.str();
    }

    ofstream dataFile( (logDirectory + dataDirectory + plotFileName + ".txt").data(), ios_base::trunc);

    if( dataFile.fail()){
        cerr << "Error: Unable to open temporary data file \"" << logDirectory + dataDirectory + plotFileName + ".txt" << "\"." << endl;
        return "";
    }

    for( unsigned i = 0; i < longestLine; i++){
        for( unsigned line = 0; line < valuesY.size(); line++) {
            if( valuesY[ line].size() > i){
                dataFile << valuesX[ line][i] << ' '<< valuesY[ line][i] << ' ';   
            } else {
                dataFile << valuesX[ line].back() << ' '<< valuesY[ line].back() << ' ';   
            }
        }
        dataFile << endl;
    }

    if( dataFile.fail()){
        cerr << "Error: Unable to write to temporary data file \"" << logDirectory + dataDirectory + plotFileName + ".txt" << "\"." << endl;
        return "";
    }

    dataFile.close();

    ofstream plotScr( (logDirectory + dataDirectory + "GNUPlotScript.txt").data(), ios_base::trunc);

    if( plotScr.fail()){
        cerr << "Error: Unable to open temporary GNUPlot script file \"" << logDirectory + dataDirectory + "GNUPlotScript.txt" << "\"." << endl;
        return "";
    }

    // prepare the plot
    plotScr << "set terminal png" << endl;
    plotScr << "set output \"" << logDirectory + dataDirectory + plotFileName << ".png\"" << endl;
    plotScr << "set grid" << endl;
    plotScr << "set title \"" << plotName<< "\"" << endl;
    plotScr << plotProp << endl;

    // plot the values
    plotScr << "plot ";
    for( unsigned i = 0; i < valuesY.size(); i++){
        plotScr << "\"" << logDirectory + dataDirectory << plotFileName + ".txt\" using " << i*2 + 1 << ':' << i*2 + 2 << " title \"" << variableNames[i] << "\"";
        if( lineProp.size() > i){
            plotScr << ' ' << lineProp[i];
        }
        if( i == valuesY.size() - 1){
            plotScr << " with lines ";
        } else {
            plotScr << " with lines, ";
        }
    }

    plotScr << endl;

    if( plotScr.fail()){
        cerr << "Error: Unable to write to temporary GNUPlot script file \"" << logDirectory + dataDirectory + "GNUPlotScript.txt" << "\"." << endl;
        return "";
    }
    plotScr.close();

    string s = GNUPLOT + logDirectory + dataDirectory + "GNUPlotScript.txt";
    system( changeSlashes(s).data());

     return dataDirectory + plotFileName + ".png"; 
}


static unsigned imageCount = 0;



string num2str( int value, int length){
    stringstream ss;
    ss << value;
    string s( ss.str());
    string result;

    if( (int) s.length() < length){ 
        for( int i = 0; i < length; i++){
            if( length - i - (signed)(s.length()) > 0){
                result.push_back( '0');
            } else {
                result.push_back( s[ 0 - ( length - i - (signed)(s.length()))] );
            }
        }
    } else {
        return s;
    }

    return result;
}
