/****************************************************************************/
/*                                                                          */
/*                                                                          */
/*           ImageDrw.h - Image Drawing in Windows (c) 1998 PEZIK           */
/*                                                                          */
/* na sproste C (ImageDrwC.h) prevedl Atomos                                */
/*                                                                          */
/****************************************************************************/

#ifndef _ImageDrwC_h_
#define _ImageDrwC_h_

#include "ColorDef.h"
#include "Image.h"

#ifdef USE_LIBENTRY
# include <LibEntry.h>
#endif

#ifndef LIBENTRY
# define LIBENTRY
#endif

#define DrawWithTransparentColor 1
#define DrawSetDIBitsForNonScaledImages 2
#define DrawDontPerformSmoothScaling 4
#define DrawDontPerformSmoothScalingWhenEnlarging 8
#define DrawDontPerformSmoothScalingWhenVerticallyCompressing 16

/* Note, that display only works for linear images and also, that DisplayColor
   is ignored for RGB images and that tansparency reduces performance for RGB */

// returns 1 on success, 0 on failure
bool LIBENTRY DrawImage(void * Context,ImageStruct * Image,float X,float Y,float XScale /*= 1*/,float YScale /*= 1*/,ColorType DisplayColor /*= 0xFFFFFF*/,int DrawControl /*= 0*/,ColorType TransparentColor /*= 0*/);
void LIBENTRY ImageExtent(void * Context,const ImageStruct * Image,float X,float Y,float * XMin,float * YMin,float * XMax,float * YMax,float XScale /*= 1*/,float YScale /*= 1*/);

#endif

