/****************************************************************************/
/*                                                                          */
/*                                                                          */
/*          ImageDrw.cpp - Image Drawing in Windows (c) 1998 PEZIK          */
/*                                                                          */
/*                                                                          */
/****************************************************************************/

#ifdef __BORLANDC__
#undef __USELOCALES__
#pragma package(smart_init)
#endif

#include <windows.h>
#include <math.h>

#ifdef __BORLANDC__
 #pragma hdrstop
#endif

//#include <LibEntry.h>
#include "ImageDrwC.h"

#define LIBEXPORT


unsigned char BitmapInfoData[sizeof(BITMAPINFO)+255*sizeof(RGBQUAD)];
BITMAPINFO & BitmapInfo = *((BITMAPINFO *)BitmapInfoData);
BITMAPINFO RGBBitmapInfo;
unsigned char MonoBitmapInfoData[sizeof(BITMAPINFO)+255*sizeof(RGBQUAD)];
BITMAPINFO & MonoBitmapInfo = *((BITMAPINFO *)MonoBitmapInfoData);

void LIBEXPORT BitmapInfoPalette(ColorType Color)
{
    unsigned ValueRed = (Color&0xFF)+1;
    unsigned ValueGreen = ((Color&0xFF00)>>8)+1;
    unsigned ValueBlue = ((Color&0xFF0000)>>16)+1;
    for (int i = 0;i<256;++i)
    {
        BitmapInfo.bmiColors[i].rgbBlue = (unsigned char)((i*ValueBlue)>>8);
        BitmapInfo.bmiColors[i].rgbGreen = (unsigned char)((i*ValueGreen)>>8);
        BitmapInfo.bmiColors[i].rgbRed = (unsigned char)((i*ValueRed)>>8);
        BitmapInfo.bmiColors[i].rgbReserved = (unsigned char)0;
    }
}

void LIBEXPORT MonoBitmapInfoPalette(int Index0)
{
    for (int i = 0;i<256;++i)
    {
        MonoBitmapInfo.bmiColors[i].rgbBlue = (unsigned char)(i==Index0?0:255);
        MonoBitmapInfo.bmiColors[i].rgbGreen = (unsigned char)(i==Index0?0:255);
        MonoBitmapInfo.bmiColors[i].rgbRed = (unsigned char)(i==Index0?0:255);
        MonoBitmapInfo.bmiColors[i].rgbReserved = (unsigned char)0;
    }
}

void LIBEXPORT BitmapInfoInit()
{
    BitmapInfo.bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
    // Width and Height to be defined by drawing function
    BitmapInfo.bmiHeader.biPlanes = 1;
    BitmapInfo.bmiHeader.biBitCount = 8;
    BitmapInfo.bmiHeader.biCompression = BI_RGB;
    BitmapInfo.bmiHeader.biSizeImage = 0; // Uncompressed format - need not be specified
    BitmapInfo.bmiHeader.biXPelsPerMeter = 0;
    BitmapInfo.bmiHeader.biYPelsPerMeter = 0;
    BitmapInfo.bmiHeader.biClrUsed = 0; // Maximum number of colors
    BitmapInfo.bmiHeader.biClrImportant = 0; // All colors important
    BitmapInfoPalette(0xFFFFFF);
    RGBBitmapInfo.bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
    // Width and Height to be defined by drawing function
    RGBBitmapInfo.bmiHeader.biPlanes = 1;
    RGBBitmapInfo.bmiHeader.biBitCount = 32;
    RGBBitmapInfo.bmiHeader.biCompression = BI_RGB;
    RGBBitmapInfo.bmiHeader.biSizeImage = 0; // Uncompressed format - need not be specified
    RGBBitmapInfo.bmiHeader.biXPelsPerMeter = 0;
    RGBBitmapInfo.bmiHeader.biYPelsPerMeter = 0;
    RGBBitmapInfo.bmiHeader.biClrUsed = 0; // Maximum number of colors
    RGBBitmapInfo.bmiHeader.biClrImportant = 0; // All colors important
    RGBBitmapInfo.bmiColors[0].rgbBlue = 0;
    RGBBitmapInfo.bmiColors[0].rgbGreen = 0;
    RGBBitmapInfo.bmiColors[0].rgbRed = 0;
    RGBBitmapInfo.bmiColors[0].rgbReserved = 0;
    MonoBitmapInfo.bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
    // Width and Height to be defined by drawing function
    MonoBitmapInfo.bmiHeader.biPlanes = 1;
    MonoBitmapInfo.bmiHeader.biBitCount = 8;
    MonoBitmapInfo.bmiHeader.biCompression = BI_RGB;
    MonoBitmapInfo.bmiHeader.biSizeImage = 0; // Uncompressed format - need not be specified
    MonoBitmapInfo.bmiHeader.biXPelsPerMeter = 0;
    MonoBitmapInfo.bmiHeader.biYPelsPerMeter = 0;
    MonoBitmapInfo.bmiHeader.biClrUsed = 0; // Maximum number of colors
    MonoBitmapInfo.bmiHeader.biClrImportant = 0; // All colors important
    MonoBitmapInfoPalette(0);
}

//#pragma startup BitmapInfoInit



#define DSTERASE 0x00220326

bool LIBEXPORT DrawImage(void * Context,ImageStruct * Image,float X,float Y,float XScale,float YScale,ColorType DisplayColor,int DrawControl,ColorType TransparentColor)
{
    bool Result;
    int OldStretchBltMode;

    BitmapInfoInit();

    if (ImagePixelType(Image)==Image8Linear)
    {
      LONG width = abs(Image->YOffset);
      LONG height = 0;
      unsigned char* raster = NULL;
      if ( Image->YOffset < 0 )
      {
         raster = Image->Raster+(Image->YSize-1)*Image->YOffset;
         height = Image->YSize;
      }
      else
      {
         raster = Image->Raster;
         height = -Image->YSize;
         
      }
        BitmapInfo.bmiHeader.biWidth = width;
        BitmapInfo.bmiHeader.biHeight = height;
        BitmapInfoPalette(DisplayColor);
        if ((fabs(XScale)==1)&&(fabs(YScale)==1)&&(DrawControl&DrawSetDIBitsForNonScaledImages)&&!(DrawControl&DrawWithTransparentColor))
        {
            Result = (::SetDIBitsToDevice(HDC(Context),X,Y,Image->XSize,Image->YSize,0,0,0,Image->XSize,raster,&BitmapInfo,DIB_RGB_COLORS)>=0);
        }
        else
        {
            int StretchMode = STRETCH_HALFTONE;
            if (DrawControl&DrawDontPerformSmoothScaling) StretchMode = STRETCH_DELETESCANS;
            else if ((DrawControl&DrawDontPerformSmoothScalingWhenEnlarging)&&((fabs(XScale)>1)||(fabs(YScale)>1))) StretchMode = STRETCH_DELETESCANS;
            else if ((DrawControl&DrawDontPerformSmoothScalingWhenVerticallyCompressing)&&(fabs(YScale)<1)) StretchMode = STRETCH_DELETESCANS;
            OldStretchBltMode = SetStretchBltMode(HDC(Context),StretchMode);
            if (DrawControl&DrawWithTransparentColor)
            {
              MonoBitmapInfo.bmiHeader.biWidth = width;
              MonoBitmapInfo.bmiHeader.biHeight = height;
              MonoBitmapInfoPalette(TransparentColor&0xFF);
              Result = (::StretchDIBits(HDC(Context),X,Y,XScale*Image->XSize,YScale*Image->YSize,0,0,Image->XSize,Image->YSize,raster,&BitmapInfo,DIB_RGB_COLORS,SRCINVERT)>=0);
              Result &= (::StretchDIBits(HDC(Context),X,Y,XScale*Image->XSize,YScale*Image->YSize,0,0,Image->XSize,Image->YSize,raster,&MonoBitmapInfo,DIB_RGB_COLORS,DSTERASE)>=0);
              Result &= (::StretchDIBits(HDC(Context),X,Y,XScale*Image->XSize,YScale*Image->YSize,0,0,Image->XSize,Image->YSize,raster,&BitmapInfo,DIB_RGB_COLORS,SRCINVERT)>=0);
            }
            else
            {
              Result = (::StretchDIBits(HDC(Context),X,Y,XScale*Image->XSize,YScale*Image->YSize,0,0,Image->XSize,Image->YSize,raster,&BitmapInfo,DIB_RGB_COLORS,SRCCOPY)>=0);
            }
            SetStretchBltMode(HDC(Context),OldStretchBltMode);
        }
        return Result;
    }
    else if (ImagePixelType(Image)==ImageRGBLinear)
    {
        RGBBitmapInfo.bmiHeader.biWidth = abs(Image->YOffset/4);
        RGBBitmapInfo.bmiHeader.biHeight = Image->YSize;
        //RGBBitmapInfo.bmiHeader.biBitCount = 32;
        if ((fabs(XScale)==1)&&(fabs(YScale)==1)&&(DrawControl&DrawSetDIBitsForNonScaledImages)&&!(DrawControl&DrawWithTransparentColor))
        {
            Result = (::SetDIBitsToDevice(HDC(Context),X,Y,Image->XSize,Image->YSize,0,0,0,Image->XSize,Image->YOffset>0?Image->Raster:Image->Raster+(Image->YSize-1)*Image->YOffset,&BitmapInfo,DIB_RGB_COLORS)>=0);
        }
        else
        {
            int StretchMode = STRETCH_HALFTONE;
            if (DrawControl&DrawDontPerformSmoothScaling) StretchMode = STRETCH_DELETESCANS;
            else if ((DrawControl&DrawDontPerformSmoothScalingWhenEnlarging)&&((fabs(XScale)>1)||(fabs(YScale)>1))) StretchMode = STRETCH_DELETESCANS;
            else if ((DrawControl&DrawDontPerformSmoothScalingWhenVerticallyCompressing)&&(fabs(YScale)<1)) StretchMode = STRETCH_DELETESCANS;
            OldStretchBltMode = SetStretchBltMode(HDC(Context),StretchMode);
            if (DrawControl&DrawWithTransparentColor)
            {
              HDC MonoDC = ::CreateCompatibleDC(HDC(Context));
              HBITMAP MonoBitmap = ::CreateBitmap(Image->XSize,Image->YSize,1,1,NULL);
              HBITMAP OldMonoBitmap = (HBITMAP)::SelectObject(MonoDC,MonoBitmap);
              HDC ColorDC = ::CreateCompatibleDC(HDC(Context));
              HBITMAP ColorBitmap = ::CreateCompatibleBitmap(HDC(Context),Image->XSize,Image->YSize);
              HBITMAP OldColorBitmap = (HBITMAP)::SelectObject(ColorDC,ColorBitmap);
              COLORREF TColor = TransparentColor;
              COLORREF OldMonoColor = ::SetBkColor(MonoDC,TColor);
              COLORREF OldColorColor = ::SetBkColor(ColorDC,TColor);
              Result = (::SetDIBitsToDevice(ColorDC,0,0,Image->XSize,Image->YSize,0,0,0,Image->YSize,Image->YOffset>0?Image->Raster:Image->Raster+(Image->YSize-1)*Image->YOffset,&RGBBitmapInfo,DIB_PAL_COLORS)>=0);
              Result &= (::BitBlt(MonoDC,0,0,Image->XSize,Image->YSize,ColorDC,0,0,SRCCOPY)>=0);
              Result &= (::StretchDIBits(HDC(Context),X,Y,XScale*Image->XSize,YScale*Image->YSize,0,0,Image->XSize,Image->YSize,Image->YOffset>0?Image->Raster:Image->Raster+(Image->YSize-1)*Image->YOffset,&RGBBitmapInfo,DIB_PAL_COLORS,SRCINVERT)>=0);
              Result &= (::StretchBlt(HDC(Context),X,Y,XScale*Image->XSize,YScale*Image->YSize,MonoDC,0,0,Image->XSize,Image->YSize,SRCAND)>=0);
              Result &= (::StretchDIBits(HDC(Context),X,Y,XScale*Image->XSize,YScale*Image->YSize,0,0,Image->XSize,Image->YSize,Image->YOffset>0?Image->Raster:Image->Raster+(Image->YSize-1)*Image->YOffset,&RGBBitmapInfo,DIB_RGB_COLORS,SRCINVERT)>=0);
              ::SetBkColor(MonoDC,OldMonoColor);
              ::SetBkColor(ColorDC,OldColorColor);
              ::SelectObject(MonoDC,OldMonoBitmap);
              ::DeleteDC(MonoDC);
              ::SelectObject(ColorDC,OldColorBitmap);
              ::DeleteDC(ColorDC);
              ::DeleteObject(MonoBitmap);
              ::DeleteObject(ColorBitmap);
            }
            else
            {
              Result = (::StretchDIBits(HDC(Context),X,Y,XScale*Image->XSize,YScale*Image->YSize,0,0,Image->XSize,Image->YSize,Image->YOffset>0?Image->Raster:Image->Raster+(Image->YSize-1)*Image->YOffset,&RGBBitmapInfo,DIB_RGB_COLORS,SRCCOPY)>=0);
            }
            SetStretchBltMode(HDC(Context),OldStretchBltMode);
        }
        return Result;
    }
    else if (ImagePixelType(Image)==ImageRGB)
    {
        RGBBitmapInfo.bmiHeader.biWidth = abs(Image->YOffset/3);
        RGBBitmapInfo.bmiHeader.biHeight = Image->YOffset > 0 ? -Image->YSize : Image->YSize;
        RGBBitmapInfo.bmiHeader.biBitCount = 24;
        if ((fabs(XScale)==1)&&(fabs(YScale)==1)&&(DrawControl&DrawSetDIBitsForNonScaledImages)&&!(DrawControl&DrawWithTransparentColor))
        {
            Result = (::SetDIBitsToDevice(HDC(Context),X,Y,Image->XSize,Image->YSize,0,0,0,Image->XSize,Image->YOffset>0?Image->Raster:Image->Raster+(Image->YSize-1)*Image->YOffset,&BitmapInfo,DIB_RGB_COLORS)>=0);
        }
        else
        {
            int StretchMode = STRETCH_HALFTONE;
            if (DrawControl&DrawDontPerformSmoothScaling) StretchMode = STRETCH_DELETESCANS;
            else if ((DrawControl&DrawDontPerformSmoothScalingWhenEnlarging)&&((fabs(XScale)>1)||(fabs(YScale)>1))) StretchMode = STRETCH_DELETESCANS;
            else if ((DrawControl&DrawDontPerformSmoothScalingWhenVerticallyCompressing)&&(fabs(YScale)<1)) StretchMode = STRETCH_DELETESCANS;
            OldStretchBltMode = SetStretchBltMode(HDC(Context),StretchMode);
            if (DrawControl&DrawWithTransparentColor)
            {
              HDC MonoDC = ::CreateCompatibleDC(HDC(Context));
              HBITMAP MonoBitmap = ::CreateBitmap(Image->XSize,Image->YSize,1,1,NULL);
              HBITMAP OldMonoBitmap = (HBITMAP)::SelectObject(MonoDC,MonoBitmap);
              HDC ColorDC = ::CreateCompatibleDC(HDC(Context));
              HBITMAP ColorBitmap = ::CreateCompatibleBitmap(HDC(Context),Image->XSize,Image->YSize);
              HBITMAP OldColorBitmap = (HBITMAP)::SelectObject(ColorDC,ColorBitmap);
              COLORREF TColor = TransparentColor;
              COLORREF OldMonoColor = ::SetBkColor(MonoDC,TColor);
              COLORREF OldColorColor = ::SetBkColor(ColorDC,TColor);
              Result = (::SetDIBitsToDevice(ColorDC,0,0,Image->XSize,Image->YSize,0,0,0,Image->YSize,Image->YOffset>0?Image->Raster:Image->Raster+(Image->YSize-1)*Image->YOffset,&RGBBitmapInfo,DIB_PAL_COLORS)>=0);
              Result &= (::BitBlt(MonoDC,0,0,Image->XSize,Image->YSize,ColorDC,0,0,SRCCOPY)>=0);
              Result &= (::StretchDIBits(HDC(Context),X,Y,XScale*Image->XSize,YScale*Image->YSize,0,0,Image->XSize,Image->YSize,Image->YOffset>0?Image->Raster:Image->Raster+(Image->YSize-1)*Image->YOffset,&RGBBitmapInfo,DIB_PAL_COLORS,SRCINVERT)>=0);
              Result &= (::StretchBlt(HDC(Context),X,Y,XScale*Image->XSize,YScale*Image->YSize,MonoDC,0,0,Image->XSize,Image->YSize,SRCAND)>=0);
              Result &= (::StretchDIBits(HDC(Context),X,Y,XScale*Image->XSize,YScale*Image->YSize,0,0,Image->XSize,Image->YSize,Image->YOffset>0?Image->Raster:Image->Raster+(Image->YSize-1)*Image->YOffset,&RGBBitmapInfo,DIB_RGB_COLORS,SRCINVERT)>=0);
              ::SetBkColor(MonoDC,OldMonoColor);
              ::SetBkColor(ColorDC,OldColorColor);
              ::SelectObject(MonoDC,OldMonoBitmap);
              ::DeleteDC(MonoDC);
              ::SelectObject(ColorDC,OldColorBitmap);
              ::DeleteDC(ColorDC);
              ::DeleteObject(MonoBitmap);
              ::DeleteObject(ColorBitmap);
            }
            else
            {
              Result = (::StretchDIBits(HDC(Context),X,Y,XScale*Image->XSize,YScale*Image->YSize,0,0,Image->XSize,Image->YSize,Image->YOffset>0?Image->Raster:Image->Raster+(Image->YSize-1)*Image->YOffset,&RGBBitmapInfo,DIB_RGB_COLORS,SRCCOPY)>=0);
            }
            SetStretchBltMode(HDC(Context),OldStretchBltMode);
        }
        return Result;
    }
    else return 0;
}

#pragma argsused
void LIBEXPORT ImageExtent(void * Context,const ImageStruct * Image,float X,float Y,float & XMin,float & YMin,float & XMax,float & YMax,float XScale,float YScale)
{
    XMin = X;
    YMin = Y;
    XMax = X+Image->XSize*XScale-1;
    YMax = Y+Image->YSize*YScale-1;
}

