/* 
   DigILibDraw.cpp
   Author: Jiri Venera
   Email: venera@fit.vutbr.cz
   
   Simple demonstration using of OpenCVDigILibBridge library.
*/

#include "stdafx.h"
#include <commdlg.h>
#include "CVDLBridge.h"
#include "DigILibDraw.h"
#include "highgui.h"
#include "ImageDrwC.h"
#include "CVDLEdge.h"
#include "CVDLLogPolar.h"
#include "CVDLSobel.h"

#define MAX_LOADSTRING 100

HINSTANCE hDLL = NULL;
typedef int (*PDrawImageProc)(void* ,ImageStruct*,float,float,float,float,ColorType,int,ColorType);


#define CNT_TESTS 3
CVDL_TEST cvdl_test[CNT_TESTS];


// Global Variables:
HINSTANCE hInst;								// current instance
TCHAR szTitle[MAX_LOADSTRING];					// The title bar text
TCHAR szWindowClass[MAX_LOADSTRING];			// the main window class name


ImageStruct* Image2Draw = NULL;
ImageStruct* originalImage = NULL;
ImageStruct* image8Linear = NULL;

ImageStruct* ImageReferenceStepAlloc = NULL;

// Forward declarations of functions included in this code module:
ATOM				MyRegisterClass(HINSTANCE hInstance);
BOOL				InitInstance(HINSTANCE, int);
LRESULT CALLBACK	WndProc(HWND, UINT, WPARAM, LPARAM);
INT_PTR CALLBACK	About(HWND, UINT, WPARAM, LPARAM);

void TestsInit();


int APIENTRY _tWinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPTSTR    lpCmdLine,
                     int       nCmdShow)
{
	UNREFERENCED_PARAMETER(hPrevInstance);
	UNREFERENCED_PARAMETER(lpCmdLine);

 	// TODO: Place code here.
	MSG msg;
	HACCEL hAccelTable;

	// Initialize global strings
	LoadString(hInstance, IDS_APP_TITLE, szTitle, MAX_LOADSTRING);
	LoadString(hInstance, IDC_DIGILIBDRAW, szWindowClass, MAX_LOADSTRING);
	MyRegisterClass(hInstance);
	
   TestsInit();


	// Perform application initialization:
	if (!InitInstance (hInstance, nCmdShow))
	{
		return FALSE;
	}

	hAccelTable = LoadAccelerators(hInstance, MAKEINTRESOURCE(IDC_DIGILIBDRAW));
	
	
	
	
	cvNamedWindow( "image", 1 ); // create HighGUI window with name "image"
	
	//cvvWaitKey(0);

	// Main message loop:
	while (GetMessage(&msg, NULL, 0, 0))
	{
		if (!TranslateAccelerator(msg.hwnd, hAccelTable, &msg))
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}
   if ( hDLL != NULL )
   {
      FreeLibrary(hDLL);
      hDLL = NULL;
   }
	return (int) msg.wParam;
}

void TestEdge( char* file_name )
{
   {
      //testEdgeHwnd = CreateWindow(szWindowClass, szTitle, WS_OVERLAPPEDWINDOW,
      //   CW_USEDEFAULT, 0, CW_USEDEFAULT, 0, NULL, NULL, NULL, NULL);


      //ShowWindow(testEdgeHwnd, SW_SHOW);
      //UpdateWindow(testEdgeHwnd);
   }
   //testEdgeHwnd = CreateWindow(
   //if( (image = cvLoadImage( filename, 1)) == 0 )
   //  return -1;

   //// Create the output image
   //cedge = cvCreateImage(cvSize(image->width,image->height), IPL_DEPTH_8U, 3);

   //// Convert to grayscale
   //gray = cvCreateImage(cvSize(image->width,image->height), IPL_DEPTH_8U, 1);
   //edge = cvCreateImage(cvSize(image->width,image->height), IPL_DEPTH_8U, 1);
   //cvCvtColor(image, gray, CV_BGR2GRAY);

   //// Create a window
   //cvNamedWindow(wndname, 1);

}



void TestsInit()
{
   
   memcpy((void*)&cvdl_test[0],(const void*)&edge_cvdl_test, sizeof(CVDL_TEST));
   memcpy((void*)&cvdl_test[1],(const void*)&logpolar_cvdl_test, sizeof(CVDL_TEST));
   memcpy((void*)&cvdl_test[2],(const void*)&sobel_cvdl_test, sizeof(CVDL_TEST));
   
}



//
//  FUNCTION: MyRegisterClass()
//
//  PURPOSE: Registers the window class.
//
//  COMMENTS:
//
//    This function and its usage are only necessary if you want this code
//    to be compatible with Win32 systems prior to the 'RegisterClassEx'
//    function that was added to Windows 95. It is important to call this function
//    so that the application will get 'well formed' small icons associated
//    with it.
//
ATOM MyRegisterClass(HINSTANCE hInstance)
{
	WNDCLASSEX wcex;

	wcex.cbSize = sizeof(WNDCLASSEX);

	wcex.style			= CS_HREDRAW | CS_VREDRAW;
	wcex.lpfnWndProc	= WndProc;
	wcex.cbClsExtra		= 0;
	wcex.cbWndExtra		= 0;
	wcex.hInstance		= hInstance;
	wcex.hIcon			= LoadIcon(hInstance, MAKEINTRESOURCE(IDI_DIGILIBDRAW));
	wcex.hCursor		= LoadCursor(NULL, IDC_ARROW);
	wcex.hbrBackground	= (HBRUSH)(COLOR_WINDOW+1);
	wcex.lpszMenuName	= MAKEINTRESOURCE(IDC_DIGILIBDRAW);
	wcex.lpszClassName	= szWindowClass;
	wcex.hIconSm		= LoadIcon(wcex.hInstance, MAKEINTRESOURCE(IDI_SMALL));

	return RegisterClassEx(&wcex);
}

//
//   FUNCTION: InitInstance(HINSTANCE, int)
//
//   PURPOSE: Saves instance handle and creates main window
//
//   COMMENTS:
//
//        In this function, we save the instance handle in a global variable and
//        create and display the main program window.
//
BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
{
   HWND hWnd;

   hInst = hInstance; // Store instance handle in our global variable

   hWnd = CreateWindow(szWindowClass, szTitle, WS_OVERLAPPEDWINDOW,
      CW_USEDEFAULT, 0, CW_USEDEFAULT, 0, NULL, NULL, hInstance, NULL);

   if (!hWnd)
   {
      return FALSE;
   }

   ShowWindow(hWnd, nCmdShow);
   UpdateWindow(hWnd);

   return TRUE;
}



//
//  FUNCTION: WndProc(HWND, UINT, WPARAM, LPARAM)
//
//  PURPOSE:  Processes messages for the main window.
//
//  WM_COMMAND	- process the application menu
//  WM_PAINT	- Paint the main window
//  WM_DESTROY	- post a quit message and return
//
//

ImageStruct* isImg = NULL;
LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	int wmId, wmEvent;
	PAINTSTRUCT ps;
	HDC hdc;

	switch (message)
	{
	case WM_COMMAND:
		wmId    = LOWORD(wParam);
		wmEvent = HIWORD(wParam);
		// Parse the menu selections:
		switch (wmId)
		{
		case IDM_ABOUT:
			DialogBox(hInst, MAKEINTRESOURCE(IDD_ABOUTBOX), hWnd, About);
			break;
		case IDM_EXIT:
			DestroyWindow(hWnd);

			break;
		
		case ID_FILE_OPEN :
		{
		   OPENFILENAME ofn;       // common dialog box structure
         char szFile[256] = {0};       // buffer for file name
         
         ZeroMemory(&ofn, sizeof(ofn));
         ofn.lStructSize = sizeof(ofn);
         ofn.hwndOwner = hWnd;
         ofn.lpstrFile = szFile;
         //
         // Set lpstrFile[0] to '\0' so that GetOpenFileName does not 
         // use the contents of szFile to initialize itself.
         //
         ofn.lpstrFile[0] = '\0';
         ofn.nMaxFile = sizeof(szFile);
         ofn.lpstrFilter = "Image\0*.jpg; *.bmp; *.tiff; *.tif\0";
         ofn.nFilterIndex = 1;
         ofn.lpstrFileTitle = NULL;
         ofn.nMaxFileTitle = 0;
         ofn.lpstrInitialDir = NULL;
         ofn.Flags = OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST;
         if (GetOpenFileName(&ofn)) 
         {
            for ( int i = 0; i < CNT_TESTS; i++ )
            {
               cvdl_test[i].test_init(ofn.lpstrFile,szWindowClass);
               InvalidateRect(*cvdl_test[i].hWndTest,NULL,TRUE);
            }
            originalImage = CreateImageFile(ofn.lpstrFile,0,NULL,NULL);
            IplImage* img = ImageStruct2IplImage(&originalImage);
            
            
            cvReleaseImage(&img);
            
            img = cvLoadImage(ofn.lpstrFile);

            cvvShowImage( "image", img);
            
            DeleteImage(isImg);
            
            isImg = IplImage2ImageStruct(&img );
            
            
            
         }         
         
         InvalidateRect(hWnd,NULL,TRUE);

		   
		}
		break;
		case ID_IMAGES_RGBLINEAR :
		   Image2Draw = originalImage;
		   InvalidateRect(hWnd,NULL,TRUE);
		break;
		case ID_IMAGES_NEWIMAGEREFERENCESTEPALLOC :
         Image2Draw = ImageReferenceStepAlloc;
         InvalidateRect(hWnd,NULL,TRUE);
		break;
		default:
			return DefWindowProc(hWnd, message, wParam, lParam);
		}
		break;
	case WM_PAINT:
   {
		
		// TODO: Add any drawing code here...
		int drawn = 0;
		hdc = BeginPaint(hWnd, &ps);
		
		for ( int i = 0; i < CNT_TESTS; i++ )
      {
         if (*cvdl_test[i].hWndTest == hWnd )
         {
            cvdl_test[i].test_draw(hdc);
            drawn = 1;
         }
      }
		if ( !drawn )
		{
		    
         if ( isImg )
		      DrawImage(hdc,(ImageStruct*)isImg,0.0f,0.0f,1.0f,1.0f,0xFFFFFF,0,0);
		   
		}
		EndPaint(hWnd, &ps);
		}
		break;
	case WM_DESTROY:
		PostQuitMessage(0);
	   for ( int i = 0; i < CNT_TESTS; i++ )
      {
         cvdl_test[i].test_done();
      }
      DeleteImage(isImg);
		break;
	default:
		return DefWindowProc(hWnd, message, wParam, lParam);
	}
	return 0;
}

// Message handler for about box.
INT_PTR CALLBACK About(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	UNREFERENCED_PARAMETER(lParam);
	switch (message)
	{
	case WM_INITDIALOG:
		return (INT_PTR)TRUE;

	case WM_COMMAND:
		if (LOWORD(wParam) == IDOK || LOWORD(wParam) == IDCANCEL)
		{
			EndDialog(hDlg, LOWORD(wParam));
			return (INT_PTR)TRUE;
		}
		break;
	}
	return (INT_PTR)FALSE;
}
