/* 
   CVDLLogPolar.cpp
   Author: Jiri Venera
   Email: venera@fit.vutbr.cz
   This example shows simple demonstration of cvdlBridge library. 
   For image loaded by DigILib library is cvSobel OpenCV function called.
   For image drawing are used both formats (ImageStruct and IplImage) which are obtained dynamically, 
   during running of program.
*/
#include "CVDLSobel.h"

#include "ImageDrwC.h"
#include "ImageFun.h"
#include <commdlg.h>
#include <string>
#include <highgui.h>

const char* test_name = "sobel-x";

CVDL_TEST sobel_cvdl_test = {&sobel_window,test_sobel_init,test_sobel_draw,test_sobel_done};
HWND sobel_window = NULL;
std::string openCVWin;

static ImageStruct* imgStruct = NULL;

void test_sobel_init(const char* file_name, TCHAR* win_class )
{
   if ( !sobel_window )
   {
      sobel_window = CreateWindow(win_class, test_name , WS_OVERLAPPEDWINDOW,
      CW_USEDEFAULT, 0, CW_USEDEFAULT, 0, NULL, NULL, (HINSTANCE)0, NULL);

      if (!sobel_window)
      {
         return;
      }

      ShowWindow(sobel_window, SW_SHOW);
      UpdateWindow(sobel_window);
   }
   
   openCVWin = std::string("OpenCV") + std::string(test_name); 
   
   cvNamedWindow( openCVWin.c_str(), 1 );
   
   if (imgStruct)
   {
      DeleteImage(imgStruct);
      imgStruct = NULL;
   }
   
   if ( file_name )
   {
       imgStruct = CreateImageFile((char*)file_name,0,NULL,NULL);
   }
   else
   {
      return;
   }
   
   IplImage* grayImage = cvCreateImage(cvSize(imgStruct->XSize , imgStruct->YSize),IPL_DEPTH_8U,1);
   ImageStruct* isGray = IplImage2ImageStruct(&grayImage);
   
   if (imgStruct->PixelType == ImageRGB||imgStruct->PixelType == ImageRGBLinear)
   {
   
      ImageRGBToImage8(isGray,imgStruct,0.0f,255.0f);
   }
   else if (imgStruct->PixelType == Image8Linear)
   {
      Image8ToImage8(isGray,imgStruct,0.0f,255.0f);
   }
   else
   {
      DeleteImage(imgStruct);
      imgStruct = NULL;
      DeleteImage(isGray);
      return;
   }
   
   
   
   IplImage* iplGray = ImageStruct2IplImage(&isGray);
   
   ImageStruct* sobelStr = NewImage16(imgStruct->XSize,imgStruct->YSize);
   
   IplImage* iplSobel = ImageStruct2IplImage(&sobelStr);
   
   cvSobel(iplGray,iplSobel,1,0,5);
   
   //cvReleaseImage(iplGray);
   
   cvConvertScaleAbs(iplSobel,iplGray);
   cvReleaseImage(&iplSobel);
   
   
   DeleteImage(imgStruct);
   imgStruct = NULL;
   
   imgStruct = IplImage2ImageStruct(&iplGray);
   cvReleaseImage(&iplSobel);
   //cvReleaseImage(&iplGray);
   
   //DeleteImage(sobelStr);
   
}

void test_sobel_draw(HDC hdc)
{
   if (imgStruct && hdc )
   {
      DrawImage(hdc,(ImageStruct*)imgStruct,0.0f,0.0f,1.0f,1.0f,0xFFFFFF,0,0);
   }
   if ( imgStruct )
   {
      IplImage* ocvImg = ImageStruct2IplImage(&imgStruct);
      cvShowImage(openCVWin.c_str(),ocvImg);
      imgStruct = IplImage2ImageStruct(&ocvImg);
   }
}

void test_sobel_done()
{

   if (imgStruct)
   {
      IplImage* ocvImg = ImageStruct2IplImage(&imgStruct);
      cvReleaseImage(&ocvImg);      
   }
   if ( !sobel_window )
   {
      DestroyWindow(sobel_window);
   }
}