/* 
   CVDLLogPolar.cpp
   Author: Jiri Venera
   Email: venera@fit.vutbr.cz
   This example shows simple using of cvdlBridge library. 
   For image loaded by DigILib library is cvLogPolar OpenCV function called.
   For image drawing are used both formats (ImageStruct and IplImage) which are obtained dynamically, 
   during running of program.
*/
#include "CVDLLogPolar.h"
#include "ImageDrwC.h"
#include <commdlg.h>
#include <cv.h>
#include <highgui.h>

CVDL_TEST logpolar_cvdl_test = {&logpolar_window,test_logpolar_init,test_logpolar_draw,test_logpolar_done};
HWND logpolar_window = NULL;

static ImageStruct* imgStruct = NULL;



void test_logpolar_init(const char* file_name, TCHAR* win_class )
{
   if ( !logpolar_window )
   {
      logpolar_window = CreateWindow(win_class, "log-polar", WS_OVERLAPPEDWINDOW,
      CW_USEDEFAULT, 0, CW_USEDEFAULT, 0, NULL, NULL, (HINSTANCE)0, NULL);

      if (!logpolar_window)
      {
         return;
      }

      ShowWindow(logpolar_window, SW_SHOW);
      UpdateWindow(logpolar_window);
   }
   
   if (imgStruct)
   {
      DeleteImage(imgStruct);
      imgStruct = NULL;
   }
   
   if ( file_name )
   {
       imgStruct = CreateImageFile((char*)file_name,0,NULL,NULL);
   }
   else
   {
      return;
   }
  
   IplImage* src = ImageStruct2IplImage(&imgStruct);


   IplImage* dst = cvCreateImage( cvGetSize(src), src->depth, src->nChannels );
        //IplImage* src2 = cvCreateImage( cvGetSize(src), src->depth, src->nChannels );
        cvLogPolar( src, dst, cvPoint2D32f(src->width/2,src->height/2), 40, CV_INTER_LINEAR+CV_WARP_FILL_OUTLIERS );
        //cvLogPolar( dst, src2, cvPoint2D32f(src->width/2,src->height/2), 40, CV_INTER_LINEAR+CV_WARP_FILL_OUTLIERS+CV_WARP_INVERSE_MAP );
        //cvNamedWindow( "log-polar", 1 );
        //cvShowImage( "log-polar", dst );
   cvReleaseImage(&src);
   imgStruct = IplImage2ImageStruct(&dst);
        /*cvNamedWindow( "inverse log-polar", 1 );
        cvShowImage( "inverse log-polar", src2 );
        cvWaitKey();*/

    
}
   


void test_logpolar_draw(HDC hdc)
{
   if (imgStruct && hdc )
   {
      DrawImage(hdc,(ImageStruct*)imgStruct,0.0f,0.0f,1.0f,1.0f,0xFFFFFF,0,0);
   }
}

void test_logpolar_done()
{

   if (imgStruct)
   {
      DeleteImage(imgStruct);
      imgStruct = NULL;
   }
   if ( !logpolar_window )
   {
      DestroyWindow(logpolar_window);
   }
}