/* 
   CVDLEdge.cpp
   Author: Jiri Venera
   Email: venera@fit.vutbr.cz
   This example shows simple using of cvdlBridge library for edges detection by canny operator. 
   For image drawing are used both formats (ImageStruct and IplImage) which are obtained dynamically, 
   during running of program.
*/
#include "CVDLEdge.h"
#include "ImageDrwC.h"
#include <commdlg.h>
#include <string>
#include <highgui.h>

CVDL_TEST edge_cvdl_test = {&edge_window,test_edge_init,test_edge_draw,test_edge_done};
HWND edge_window = NULL;

static ImageStruct* imgStruct = NULL;

const char* t_name = "canny";
std::string oCVWin;



void test_edge_init(const char* file_name, TCHAR* win_class )
{
   if ( !edge_window )
   {
      edge_window = CreateWindow(win_class, t_name, WS_OVERLAPPEDWINDOW,
      CW_USEDEFAULT, 0, CW_USEDEFAULT, 0, NULL, NULL, (HINSTANCE)0, NULL);

      if (!edge_window)
      {
         return;
      }

      ShowWindow(edge_window, SW_SHOW);
      UpdateWindow(edge_window);
   }
   
   
   oCVWin = std::string("OpenCV") + std::string(t_name); 
   
   cvNamedWindow( oCVWin.c_str(), 1 );
   
   if (imgStruct)
   {
      DeleteImage(imgStruct);
      imgStruct = NULL;
   }
   
   if ( file_name )
   {
       imgStruct = CreateImageFile((char*)file_name,0,NULL,NULL);
   }
   else
   {
      return;
   }
   IplImage* iplImg = ImageStruct2IplImage(&imgStruct);
   if(!iplImg)
   {
      DeleteImage(imgStruct);
      imgStruct = NULL;
   }
   
    // Create the output image
   //IplImage* cedge = cvCreateImage(cvSize(iplImg->width,iplImg->height), IPL_DEPTH_8U, 4);
   IplImage* cedge = cvCloneImage(iplImg);

   // Convert to grayscale
   IplImage* gray = cvCreateImage(cvSize(iplImg->width,iplImg->height), IPL_DEPTH_8U, 1);
   IplImage* edge = cvCreateImage(cvSize(iplImg->width,iplImg->height), IPL_DEPTH_8U, 1);
   
   if ( iplImg->nChannels == 4 )
   {
      cvCvtColor(iplImg, gray, CV_BGRA2GRAY);
   }
   else if ( iplImg->nChannels == 3 )
   {
      cvCvtColor(iplImg, gray, CV_BGR2GRAY);
   }
   else if (iplImg->nChannels == 1)
   {
      cvCopyImage(iplImg,gray);
   }
   
   cvSmooth( gray, edge, CV_BLUR, 3, 3, 0 );
   cvNot( gray, edge );

   // Run the edge detector on grayscale
   cvCanny(gray, edge, (float)50, (float)150);

   cvZero( cedge );
   // copy edge points
   cvCopy( iplImg, cedge, edge );

   //cvShowImage(wndname, cedge);

   cvReleaseImage(&iplImg);
   //imgStruct = IplImage2ImageStruct(&iplImg);
   imgStruct = IplImage2ImageStruct(&cedge);
   //cvReleaseImage(&cedge);
   cvReleaseImage(&gray);
   cvReleaseImage(&edge);
}

void test_edge_draw(HDC hdc)
{
   if (imgStruct && hdc )
   {
      DrawImage(hdc,(ImageStruct*)imgStruct,0.0f,0.0f,1.0f,1.0f,0xFFFFFF,0,0);
   }
   if ( imgStruct )
   {
      IplImage* ocvImg = ImageStruct2IplImage(&imgStruct);
      cvShowImage(oCVWin.c_str(),ocvImg);
      imgStruct = IplImage2ImageStruct(&ocvImg);
   }
}

void test_edge_done()
{

   if (imgStruct)
   {
      IplImage* ocvImg = ImageStruct2IplImage(&imgStruct);
      cvReleaseImage(&ocvImg);   
   }
   if ( !edge_window )
   {
      DestroyWindow(edge_window);
   }
}