#ifndef _VECTFUN
#define _VECTFUN

#ifdef USE_LIBENTRY
# include <LibEntry.h>
#endif

#ifndef LIBENTRY
# define LIBENTRY
#endif

typedef struct VectorStruct {
  float * Data;
  int Count;
  int MaxCount;
  void (*Callback)(struct VectorStruct * Vector,void * ID);
  void * ID;
  void * ExtraInfo;
  int DestroyData;
} VectorStruct;

#define VectorElement(Vector,Index) ((Vector)->Data[(Index)])
#define SetVectorElement(Vector,Index,Value) { ((Vector)->Data[(Index)]) = (Value); }
#define VectorOffset(Vector) (1)
#define VectorCount(Vector) ((Vector)->Count)
#define VectorMaxCount(Vector) ((Vector)->MaxCount)
#define VectorData(Vector) ((Vector)->Data)
#define UpdateVectorCount(Vector,NewCount) { (Vector)->Count = (NewCount); }
#define VectorExtraInfo(Vector) ((Vector)->ExtraInfo)


#ifdef __cplusplus
extern "C" {
#endif

int LIBENTRY InitVectorSize(VectorStruct * Vector,int MaxCount);
void LIBENTRY InitVectorBase(VectorStruct * Vector,float * Base,int MaxCount);
int LIBENTRY InitVectorCopy(VectorStruct * Vector,const VectorStruct * Original);
int LIBENTRY CopyVector(VectorStruct * Vector,const VectorStruct * Original);
void LIBENTRY DestroyVector(VectorStruct * Vector);

void LIBENTRY VectorStatistics(float * Min,float * Max,float * Mean,float * SumSquares,const VectorStruct * Vector);

int LIBENTRY VectorsAddToVector(VectorStruct * DstVector,const VectorStruct * SrcVector1,const VectorStruct * SrcVector2);
int LIBENTRY VectorsSubtractToVector(VectorStruct * DstVector,const VectorStruct * SrcVector1,const VectorStruct * SrcVector2);
int LIBENTRY VectorsMultiplyToVector(VectorStruct * DstVector,const VectorStruct * SrcVector1,const VectorStruct * SrcVector2);
int LIBENTRY VectorsDivideToVector(VectorStruct * DstVector,const VectorStruct * SrcVector1,const VectorStruct * SrcVector2);
int LIBENTRY VectorNegativeToVector(VectorStruct * DstVector,const VectorStruct * SrcVector);

int LIBENTRY VectorMaximum(const VectorStruct * Vector);
int LIBENTRY VectorMinimum(const VectorStruct * Vector);
int LIBENTRY VectorMaximumLimit(const VectorStruct * Vector,int Low,int High);
int LIBENTRY VectorMinimumLimit(const VectorStruct * Vector,int Low,int High);

#ifdef __cplusplus
}
#endif

#endif
