#ifndef _IMAGEFUN
#define _IMAGEFUN

#include "ColorDef.h"
#include "Image.h"


#ifdef USE_LIBENTRY
# include <LibEntry.h>
#endif

#ifndef LIBENTRY
# define LIBENTRY
#endif

#ifdef __cplusplus
extern "C" {
#endif

ImageStruct * LIBENTRY ImageCopy(const ImageStruct * Image);
int LIBENTRY ImageTransfer(ImageStruct * DstImage,const ImageStruct * SrcImage);
int LIBENTRY ImageFill(ImageStruct * Image,float Value);

int LIBENTRY ImageInfoTransfer(ImageStruct * DstImage,const ImageStruct * SrcImage);

int LIBENTRY Image8Negate(ImageStruct * Result,const ImageStruct * Image);

int LIBENTRY ImageFloatMul(ImageStruct * Result,const ImageStruct * Image,float Coef);
int LIBENTRY ImageImageMul(ImageStruct * Result,const ImageStruct * Image1,const ImageStruct * Image2);

int LIBENTRY ImageStatistics(float * Min,float * Max,float * Mean,float * SumSquares,const ImageStruct * Image);
int LIBENTRY Image2Statistics(float * MinSize,float * MaxSize,float * MeanSize,const ImageStruct * Image1,const ImageStruct * Image2);

int LIBENTRY Image8ToImage16(ImageStruct * DstImage16,const ImageStruct * SrcImage8);
int LIBENTRY Image8ToImage32(ImageStruct * DstImage32,const ImageStruct * SrcImage8);
int LIBENTRY Image8ToImageFloat(ImageStruct * DstImageFloat,const ImageStruct * SrcImage8);
int LIBENTRY Image8ToImageRGB(ImageStruct * DstImageRGB,const ImageStruct * SrcImage8);
int LIBENTRY Image8ToImageComplex(ImageStruct * DstImageComplex,const ImageStruct * SrcImage8);

int LIBENTRY Image8ToImage8(ImageStruct * DstImage8,const ImageStruct * SrcImage8,float MinValue,float MaxValue);
int LIBENTRY Image16ToImage8(ImageStruct * DstImage8,const ImageStruct * SrcImage16,float MinValue,float MaxValue);
int LIBENTRY Image32ToImage8(ImageStruct * DstImage8,const ImageStruct * SrcImage32,float MinValue,float MaxValue);
int LIBENTRY ImageFloatToImage8(ImageStruct * DstImage8,const ImageStruct * SrcImageFloat,float MinValue,float MaxValue);
int LIBENTRY ImageFloatLogToImage8(ImageStruct * DstImage8,const ImageStruct * SrcImageFloat,float MinValue,float MaxValue);
int LIBENTRY ImageRGBToImage8(ImageStruct * DstImage8,const ImageStruct * SrcImageRGB,float MinValue,float MaxValue);
int LIBENTRY ImageComplexReToImage8(ImageStruct * DstImage8,const ImageStruct * SrcImageComplex,float MinValue,float MaxValue);
int LIBENTRY ImageComplexImToImage8(ImageStruct * DstImage8,const ImageStruct * SrcImageComplex,float MinValue,float MaxValue);
int LIBENTRY ImageComplexReLogToImage8(ImageStruct * DstImage8,const ImageStruct * SrcImageComplex,float MinValue,float MaxValue);
int LIBENTRY ImageComplexImLogToImage8(ImageStruct * DstImage8,const ImageStruct * SrcImageComplex,float MinValue,float MaxValue);
int LIBENTRY ImageComplexPowerToImage8(ImageStruct * DstImage8,const ImageStruct * SrcImageComplex,float MinValue,float MaxValue);
int LIBENTRY ImageComplexPowerLogToImage8(ImageStruct * DstImage8,const ImageStruct * SrcImageComplex,float MinValue,float MaxValue);

int LIBENTRY ImageRGBToImageRGB(ImageStruct * DstImageRGB,const ImageStruct * SrcImageRGB,float MinValue,float MaxValue);
int LIBENTRY ImageRGBToImageRGBColor(ImageStruct * DstImageRGB,const ImageStruct * SrcImageRGB,ColorType Color,float MinValue,float MaxValue);

int LIBENTRY ImageFloat2ToImage8(ImageStruct * DstImage8,const ImageStruct * SrcImageFloat1,const ImageStruct * SrcImageFloat2,float MinSize,float MaxSize);
int LIBENTRY ImageFloat2LogToImage8(ImageStruct * DstImage8,const ImageStruct * SrcImageFloat1,const ImageStruct * SrcImageFloat2,float MinSize,float MaxSize);

int LIBENTRY ImageSliceToFloat(float * Result,int MaxResultSize,int * ResultSize,const ImageStruct * Image,int X1,int Y1,int X2,int Y2);
int LIBENTRY Image2SliceToFloat(float * Result,int MaxResultSize,int * ResultSize,const ImageStruct * Image1,const ImageStruct * Image2,int X1,int Y1,int X2,int Y2);

#ifdef __cplusplus
}
#endif

#endif
