#include <assert.h>

#include <Inventor/cve/SbRefObject.h>



void SbRefObject::ref()
{
  refCounter++;
}


void SbRefObject::unref()
{
  assert(refCounter > 0 && "refCounter can not go below zero.");
  if (--refCounter == 0) delete this;
}


void SbRefObject::unrefNoDelete()
{
  assert(refCounter > 0 && "refCounter can not go below zero.");
  --refCounter;
}


int SbRefObject::getRefCount() const
{
  return refCounter;
}


SbRefObject::SbRefObject()
{
  refCounter = 0;
}


SbRefObject::~SbRefObject()
{
  assert(refCounter == 0 && "Destructing object with non=zero reference counter.");
}
