#ifndef SO_NETWORK_P_H_INCLUDED_
#define SO_NETWORK_P_H_INCLUDED_


#include <Inventor/lists/SbList.h>
#include <Inventor/cve/SoComputer.h>

class SbNetListener;



class SoNetworkP {
public:
  // computers and listeners
  static SoComputerList compList;
  static SoDistributionGroupList distribGroupList;
  static SbList<SbNetListener*> listenerList;

  static void addComputer(SoComputer *comp);
  static void removeComputer(SoComputer *comp);
  static void addListener(SbNetListener *listener);
  static void removeListener(SbNetListener *listener);

  static int numTrReceived;
  static int numTrExecuted;
  static int numTrScheduled;
  static int numMsgReceived;
};


class SoThisComputer : public SoComputer {
public:
  virtual State getState()  { return CONNECTED; }
  virtual SbBool isThisComputer() const;

  SoThisComputer()  { netc = 0; localAddr = addr = SbInetAddr::invalid(); localAddrState = CACHED; }
  virtual ~SoThisComputer()  {}

  virtual int  recvData(void *buf, int size)  { return 0; }
  virtual void sendData(const void *buf, int size)  { return; }
  void setLargestTimeStamp(const SbTimeStamp &ts)  { largestTimeStamp = ts; }

  virtual void sendTransaction(SbTransaction *tr)  { largestTimeStamp = tr->getTimeStamp(); } // FIXME: should it be possible to send transactions directly to the computers? (consistency reasons)
  virtual SbBool transactionReceived()  { return FALSE; }
  virtual SbTransaction* receiveTransaction(SoDistributionGroup *dg)  { return NULL; }
};


#endif /* SO_NETWORK_P_H_INCLUDED_ */
