#ifndef SOMF_COMPUTER_H
#define SOMF_COMPUTER_H


#include <Inventor/fields/SoMField.h>
#include <Inventor/fields/SoSubField.h>


class COIN_DLL_API SoMFComputer : public SoMField {
  typedef SoMField inherited;

  SO_MFIELD_HEADER(SoMFComputer, SoComputer*, SoComputer*);

public:
  static void initClass(void);

  void append(SoComputer *comp);
  void insert(SoComputer *comp, int idx);
  SoComputer* get(int idx) const;
  int find(const SoComputer *comp) const;
  void remove(int index);
  void remove(SoComputer *comp);
  void removeAll();
  void replace(int idx, SoComputer *comp);
  void replace(SoComputer *oldcomp, SoComputer *newcomp);

  //virtual void deleteValues(int start, int num = -1)
  virtual void insertSpace(int start, int num);
};


#endif // !SOMF_COMPUTER_H
