#!/bin/sh

ZIPNAME=zalohaBack-`date '+%Y%m%d%H%M'`
SRCDIR="$HOME/Repository/Projects/DBalls"
COINDIR="$HOME/Coin-2"

echo
echo "Making archive $ZIPNAME from old files..."
echo
zip "$SRCDIR/Zaloha/$ZIPNAME" \
    "$COINDIR/include/Inventor/cve"/* \
    "$COINDIR/src/cve"/* \
    "$COINDIR/include/Inventor/fields/SoField.h" \
    "$COINDIR/include/Inventor/fields/SoSubField.h" \
    "$COINDIR/src/fields/SoField.cpp" \
    "$COINDIR/src/misc/SoSceneManager.cpp"
    "$COINDIR/build/msvc6/install-cve-debug.bat" \
    "$COINDIR/build/msvc6/install-cve-headers.bat"

if [ $? != 0 ]; then
    echo "Zip failed. Maybe, Directory Zaloha is missing."
    exit 1
fi

echo
echo "Removing old files..."
echo
rm -f "$COINDIR/include/Inventor/cve"/* \
    "$COINDIR/src/cve"/*

echo
echo "Copying new files..."
echo    
cp "$SRCDIR/cveInclude"/* "$COINDIR/include/Inventor/cve/"
cp "$SRCDIR/cveSrc"/* "$COINDIR/src/cve/"
cp "$SRCDIR/cveHacked/SoField.h" "$COINDIR/include/Inventor/fields/"
cp "$SRCDIR/cveHacked/SoSubField.h" "$COINDIR/include/Inventor/fields/"
cp "$SRCDIR/cveHacked/SoField.cpp" "$COINDIR/src/fields/"
cp "$SRCDIR/cveHacked/SoSceneManager.cpp" "$COINDIR/src/misc/SoSceneManager.cpp"
cp "$SRCDIR/Utils/install-cve-debug.bat" "COINDIR/build/msvc6/install-cve-debug.bat"
cp "$SRCDIR/Utils/install-cve-headers.bat" "COINDIR/build/msvc6/install-cve-headers.bat"

echo
echo "Done."
echo
