#!/bin/sh

ZIPNAME=zalohaBack-`date '+%Y%m%d%H%M'`
SRCDIR="$HOME/Repository/Projects/DBalls"
COINDIR="$HOME/Coin-2"

echo
echo "Making archive $ZIPNAME from old files..."
echo
zip "$SRCDIR/Zaloha/$ZIPNAME" \
    "$SRCDIR/cveInclude"/* \
    "$SRCDIR/cveSrc"/* \
    "$SRCDIR/cveHacked"/*

if [ $? != 0 ]; then
    echo "Zip failed. Maybe, Directory Zaloha is missing."
    exit 1
fi

echo
echo "Removing old files..."
echo
rm -f "$SRCDIR/cveInclude"/* \
    "$SRCDIR/cveSrc"/* \
    "$SRCDIR/cveHacked"/*

echo
echo "Copying new files..."
echo    
cp "$COINDIR/include/Inventor/cve"/* "$SRCDIR/cveInclude"
cp "$COINDIR/src/cve"/* "$SRCDIR/cveSrc"
cp "$COINDIR/include/Inventor/fields/SoField.h" "$SRCDIR/cveHacked"
cp "$COINDIR/include/Inventor/fields/SoSubField.h" "$SRCDIR/cveHacked"
cp "$COINDIR/src/fields/SoField.cpp" "$SRCDIR/cveHacked"
cp "$COINDIR/src/misc/SoSceneManager.cpp" "$SRCDIR/cveHacked"

echo
echo "Done."
echo
