#ifndef SO_PERF_GRAPH_H
#define SO_PERF_GRAPH_H
/*****************************************************************************\
 *
 * SoPerfGraph.h
 *
 * Performance graph node
 *
 * Authors: PCJohn (peciva AT fit.vutbr.cz)
 * Contributors:
 *
 * ----------------------------------------------------------------------------
 *
 * THIS SOFTWARE IS NOT COPYRIGHTED
 *
 * This source code is offered for use in the public domain.
 * You may use, modify or distribute it freely.
 *
 * This source code is distributed in the hope that it will be useful but
 * WITHOUT ANY WARRANTY.  ALL WARRANTIES, EXPRESS OR IMPLIED ARE HEREBY
 * DISCLAIMED.  This includes but is not limited to warranties of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * If you find the source code useful, authors will kindly welcome
 * if you give them credit and keep their names with their source code,
 * but do not feel forced to do so.
 *
\*****************************************************************************/


#include <Inventor/nodes/SoNode.h>
#include <Inventor/fields/SoSFEnum.h>
#include <Inventor/fields/SoSFVec2s.h>
#include <Inventor/fields/SoSFVec2f.h>

class SoPerfGraphP;



class SoPerfGraph : public SoNode {

  SO_NODE_HEADER(SoPerfGraph);

protected:
  SoPerfGraphP *pimpl;

public:

  enum VertAlignment {
    BOTTOM, HALF, TOP
  };

  enum HorAlignment {
    LEFT, CENTER, RIGHT
  };

  SoSFEnum vertAlignment;
  SoSFEnum horAlignment;
  SoSFVec2f size;
  SoSFVec2f position;
  SoSFVec2s sizeInPixels;
  SoSFVec2s positionInPixels;
  SoSFEnum vertScreenOrigin;
  SoSFEnum horScreenOrigin;
  SoSFVec2f dataScale;

  
  void appendValue(float v);

  SoPerfGraph();
  SoPerfGraph(int n);

  static void initClass();
  static void cleanup();

  virtual void doAction(SoAction * action);
  virtual void callback(SoCallbackAction * action);
  virtual void GLRender(SoGLRenderAction * action);
  virtual void getBoundingBox(SoGetBoundingBoxAction * action);
  virtual void getMatrix(SoGetMatrixAction * action);
  virtual void handleEvent(SoHandleEventAction * action);
  virtual void pick(SoPickAction * action);
  virtual void getPrimitiveCount(SoGetPrimitiveCountAction * action);
  virtual void audioRender(SoAudioRenderAction * action);

  virtual SoChildList* getChildren() const;

protected:
  virtual ~SoPerfGraph();

  virtual void rasterizeColumn(unsigned char *buf, int size, const float v);
  friend class SoPerfGraphP;
};


#endif /* SO_PERF_GRAPH_H */
