// ///////////////////  ***********************  \\\\\\\\\\\\\\\\\\\\ //
//
//  This file is part of the Sector 5, 3D graphic game.
//  Copyright (C) 2000-2002 by PC John. All rights reserved.
//
//  This game is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Lesser General Public License
//  version 2.1 as published by the Free Software Foundation. See the
//  file LICENSE.LGPL at the root directory of the distribution for
//  more details.
//
//  If you want to use Sector 5 code for applications not compatible 
//  with the LGPL license, please contact PC John at pcjohn@email.cz.
//
// \\\\\\\\\\\\\\\\\\\  ***********************  //////////////////// //


#include <stdlib.h>
#include "Random.h"



int randi(int max)
{
  return (int)((float)rand() * (float)max/(float)RAND_MAX);
}



float randf(float max)
{
  return (float(rand()) / float(RAND_MAX)) * max;
}



SbVec3f randVec(float maxLen)
{
  SbVec3f v;
  do
    v.setValue(randf(maxLen)*2-maxLen, randf(maxLen)*2-maxLen, randf(maxLen)*2-maxLen);
#if 0
  while (v.length() >= maxLen); // optimized (to remove sqrt):
#else
  while (v[0]*v[0] + v[1]*v[1] + v[2]*v[2] >= maxLen*maxLen);
#endif
  return v;
}
