#ifndef BALL_H_
#define BALL_H_

#include <Inventor/SbLinear.h>
#include <Inventor/SbTime.h>
#include <Inventor/lists/SbList.h>

class SoSeparator;
class SoMatrixTransform;
class SbTransaction;
class CollisionAssert;


class Ball {
public:
  static float radius;

  SbVec3f getPos(int version = SoField::LATEST) const;
  SbVec3f getSpeed(int version = SoField::LATEST) const;
  SbTransaction* setPos(const SbVec3f &pos);
  SbTransaction* setPosAndSpeed(const SbVec3f &pos, const SbVec3f &speed, int readVersionIndex = SoField::LATEST);

  SoNode* getSceneGraph() const  { return myGraph; }
  SbBool isActive() const  { return active; }
  void activate(SoSeparator *root);
  void deactivate(SoSeparator *root);

  void randomInit(int ballIndex);
  SbTransaction* timeTick(SbTime dt);

  Ball();
  ~Ball();

  void updateCircles();
  static void cleanup();

  // used as hack to schedule a new transaction
  SbBool collisionHappened;
  SbVec3f collisionPos;
  SbVec3f collisionSpeed;

//private: - for quick development purposes commented out
  SoMatrixTransform *matrix;
  SoTranslation *speedVec;
  SoMaterial *material;
  SbList<SoSeparator*> circleList;
  static CollisionAssert *collisionAssert;
private:
  SbBool active;
  SoNode *myGraph;
  SoGroup *pendings;
  void createSceneGraph();
  void destroySceneGraph();
};


#endif /* BALL_H_ */
