#include <Inventor/misc/SbHash.h>

#include <Inventor/cve/SbUserTransaction.h>



static SbHash<SbUserTransactionCB*, const char *> name2cb;



void SbUserTransaction::setCallback(const char *name, SbUserTransactionCB *cb)
{
  name2cb.put(name, cb);
}


SbUserTransactionCB* SbUserTransaction::getCallback(const char *name)
{
  SbUserTransactionCB *cb;
  if (!name2cb.get(name, cb))
    return NULL;
  return cb;
}


void SbUserTransaction::schedule(const char *name, SoDistributionGroup *dg, const uint8_t *buf, size_t bufsize)
{
  // allocate memory
  size_t datasize = bufsize + 8;
  uint8_t *data = (uint8_t*)malloc();
  
  // write header ("TRU" and size)
  memcpy(data, "TRU", 4);
  ((uint32_t*)data)[1] = datasize;
  memcpy(&data[8], buf, bufsize);

  // send transaction
  dg->sendData(data, dataSize);

  // free memory
  free(data);
}


void SbUserTransaction::schedule(const char *name, SoDistributionGroup *dg, const uint8_t *buf, size_t bufsize)
{
  // allocate memory
  size_t datasize = bufsize + 8;
  uint8_t *data = (uint8_t*)malloc();
  
  // write header ("TRU" and size)
  memcpy(data, "TRU", 4);
  ((uint32_t*)data)[1] = datasize;
  memcpy(&data[8], buf, bufsize);

  // send transaction
  dg->sendData(data, dataSize);

  // free memory
  free(data);
}


void SbUserTransaction::execute(