#include <Inventor/lists/SbList.h>

#include <Inventor/cve/SbSceneAssert.h>


/* Don't set value explicitly to SoType::badType(), to avoid a bug in */
/* Sun CC v4.0. (Bitpattern 0x0000 equals SoType::badType()). */
SoType SbSceneAssert::classTypeId;


SbSceneAssert::SbSceneAssert() : dgroup(NULL)
{
}


SbSceneAssert::SbSceneAssert(SoDistributionGroup *dg) : dgroup(dg)
{
}


SbSceneAssert::~SbSceneAssert()
{
}


SoDistributionGroup* SbSceneAssert::getDistributionGroup() const
{
  return dgroup;
}


void SbSceneAssert::setDistributionGroup(SoDistributionGroup *dg)
{
  if (dgroup == dg)  return;
  if (dgroup != NULL) {
    assert(0 && "Attempt to register a scene assert that is already registered "
                "in another distribution group.");
    return;
  }
  dgroup = dg;
  dgroup->registerAssert(this);
}


int SbSceneAssert::getName() const
{
  SoDistributionGroup *dg = dgroup;
  return dgroup->assertList.find((SbSceneAssert*)this); // It is strange that this can not be
          // compiled without retyping on MSVC6. Bug in compiler, or am I missing something?
}


SbBool SbSceneAssert::read(SoInput *in)
{
  return TRUE;
}


void SbSceneAssert::write(SoOutput *out)
{
}

  
void SbSceneAssert::initClass()
{
  classTypeId = SoType::createType(SoType::badType(), "SbSceneAssert", NULL);
}


SoType SbSceneAssert::getClassTypeId(void) { return SbSceneAssert::classTypeId; }


SbBool SbSceneAssert::isOfType(SoType type) const
{
  return this->getTypeId().isDerivedFrom(type);
}
