##$ TEMPLATE Make-Common(-xxx-, -incdir-)
# **************************************************************************
# This template depends on the following variables having been set up before
# its invokation.
#
# PublicHeaders    - header files that should be installed
# PrivateHeaders   - source files that should be distributed, but not
#                    installed - including source-included source files.
# RegularSources   - source files compiled in this directory
# LinkHackSources  - alternative source files used on -enable-compact compilation
# ObsoletedHeaders - header files that should be removed upon installation

# Everything below is autogenerated from a macro, so don't modify
# within the Makefile.am itself. 19991201 mortene.

DISTCLEANFILES = \
	ii_files/*.ii

if HACKING_COMPACT_BUILD
BuildSources = $(LinkHackSources)
ExtraSources = $(RegularSources)
else
BuildSources = $(RegularSources)
ExtraSources = $(LinkHackSources)
endif

if BUILD_WITH_MSVC
noinst_LIBRARIES = -xxx-.lst
else
if HACKING_DYNAMIC_MODULES
lib_LTLIBRARIES = lib-xxx-@SUFFIX@LINKHACK.la
else
noinst_LTLIBRARIES = lib-xxx-.la
endif
endif

# Remove any linklibraries detected by configure, as they are not
# needed in the submodules -- only in the toplevel libCoin build.
LIBS = 

DEFAULT_INCLUDES = -I$(top_builddir)/include -I$(top_srcdir)/include $(ExtraIncludeDirs)

# header installation
if MAC_FRAMEWORK
lib-xxx-incdir = $(MAC_FRAMEWORK_PREFIX)/$(MAC_FRAMEWORK_NAME).framework/Versions/$(MAC_FRAMEWORK_VERSION)/Headers/-incdir-
# hack to change libdir value when installing Mac OS X compiler framework
lib@nop@dir = $(MAC_FRAMEWORK_PREFIX)/$(MAC_FRAMEWORK_NAME).framework/Versions/$(MAC_FRAMEWORK_VERSION)/Libraries
else
lib-xxx-incdir = $(includedir)/Inventor/-incdir-
endif
lib-xxx-inc_HEADERS = $(PublicHeaders)

lib-xxx-_la_SOURCES = $(BuildSources)
EXTRA_lib-xxx-_la_SOURCES = \
	$(PublicHeaders) $(PrivateHeaders) $(ExtraSources)

lib-xxx-@SUFFIX@LINKHACK_la_SOURCES = $(BuildSources)
EXTRA_lib-xxx-@SUFFIX@LINKHACK_la_SOURCES = \
	$(PublicHeaders) $(PrivateHeaders) $(ExtraSources)

-xxx-_lst_SOURCES = $(BuildSources)
EXTRA_-xxx-_lst_SOURCES = \
	$(PublicHeaders) $(PrivateHeaders) $(ExtraSources)

# this rule causes a make warning, so we remove it when it is not in use
-xxx-.lst: Makefile $(-xxx-_lst_OBJECTS)
	@echo "Linking -xxx-.lst..."; \
	rm -f $@; touch $@; \
	for i in $(-xxx-_lst_OBJECTS); do echo $$i >>$@; done

install-lib-xxx-incHEADERS: $(lib-xxx-inc_HEADERS)
	@$(NORMAL_INSTALL)
	@if test x"$(lib-xxx-inc_HEADERS)" = x""; then :; else \
	  echo " $(mkinstalldirs) $(DESTDIR)$(lib-xxx-incdir)"; \
	  $(mkinstalldirs) $(DESTDIR)$(lib-xxx-incdir); \
	fi
	@list='$(lib-xxx-inc_HEADERS)'; for p in $$list; do \
	  if test -f "$$p"; then d=; else d="$(srcdir)/"; fi; \
	  f="`echo $$p | sed -e 's|^.*/||'`"; \
	  src="$$d$$p"; dst="$(DESTDIR)$(lib-xxx-incdir)/$$f"; \
	  if cmp -s "$$src" "$$dst"; then :; else \
	    echo " $(INSTALL_HEADER) $$src $$dst"; \
	    $(INSTALL_HEADER) "$$src" "$$dst" || exit 1; \
	  fi \
	done
	@list='$(ObsoletedHeaders)'; for f in $$list; do \
	  file="$(DESTDIR)$(lib-xxx-incdir)/$$f"; \
	  if test -x "$$file"; then \
	    echo " rm -f $$file"; \
	    rm -f "$$file"; \
	  fi \
	done; \
	:

if MACOSX
# When using --enable-hacking, the user tends to manually replace some 
# of the installed libraries by symlinks back to the build directory. 
# But Mac OS X's install program refuses to overwrite symlinks => we 
# have to explicitly remove existing symlinks before installation.
install-exec-local:
	@for file in $(DESTDIR)$(lib@nop@dir)/lib-xxx-@SUFFIX@LINKHACK*.dylib; do \
	  if test -L "$$file"; then \
	    rm -f "$$file"; \
	  fi \
	done; 
else 
install-exec-local:
endif

install-symlinks:
	@echo "Creating symlink to lib-xxx-@SUFFIX@LINKHACK*@LIBEXT@*"; \
        for dir in $(SUBDIRS) ; do \
          (cd $$dir; $(MAKE) install-symlinks;) \
        done ; \
        here=`pwd`; \
	(cd $(DESTDIR)$(lib@nop@dir); \
	for file in lib-xxx-@SUFFIX@LINKHACK*@LIBEXT@*; do \
	  ln -sf "$$here/.libs/$$file" "$$file"; \
	done; \
        cd -; )
