/**************************************************************************\
 *
 *  This file is part of the Coin 3D visualization library.
 *  Copyright (C) 1998-2006 by Systems in Motion.  All rights reserved.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  ("GPL") version 2 as published by the Free Software Foundation.
 *  See the file LICENSE.GPL at the root directory of this source
 *  distribution for additional information about the GNU GPL.
 *
 *  For using Coin with software that can not be combined with the GNU
 *  GPL, and for taking advantage of the additional benefits of our
 *  support services, please contact Systems in Motion about acquiring
 *  a Coin Professional Edition License.
 *
 *  See http://www.coin3d.org/ for more information.
 *
 *  Systems in Motion, Postboks 1283, Pirsenteret, 7462 Trondheim, NORWAY.
 *  http://www.sim.no/  sales@sim.no  coin-support@coin3d.org
 *
\**************************************************************************/

struct hash_entry {
    unsigned long key;
    void * val;
    struct hash_entry * next;
};
typedef struct hash_entry hash_entry;

struct hash_table {
    unsigned int size;
    unsigned int elements;
    float loadfactor;
    unsigned int threshold;
    hash_entry ** buckets;
    unsigned long (*hashfunc)(const unsigned long key);
};
typedef struct hash_table hash_table;

/* Loadfactor 0.0f is interpreted as 0.75f, the default */
hash_table * HashTable_new(unsigned int size, float loadfactor);
void HashTable_delete(hash_table * ht);
void HashTable_clear(hash_table * ht);

int HashTable_put(hash_table * ht, unsigned long key, void * val);
int HashTable_get(hash_table * ht, unsigned long key, void ** val);
int HashTable_remove(hash_table * ht, unsigned long key);
unsigned int HashTable_elements(hash_table * ht);

void HashTable_setHashFunc(hash_table * ht, unsigned long (*func)(const unsigned long key));

void HashTable_print_stat(hash_table * ht);
