/**************************************************************************\
 *
 *  This file is part of the Coin 3D visualization library.
 *  Copyright (C) 1998-2006 by Systems in Motion.  All rights reserved.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  ("GPL") version 2 as published by the Free Software Foundation.
 *  See the file LICENSE.GPL at the root directory of this source
 *  distribution for additional information about the GNU GPL.
 *
 *  For using Coin with software that can not be combined with the GNU
 *  GPL, and for taking advantage of the additional benefits of our
 *  support services, please contact Systems in Motion about acquiring
 *  a Coin Professional Edition License.
 *
 *  See http://www.coin3d.org/ for more information.
 *
 *  Systems in Motion, Postboks 1283, Pirsenteret, 7462 Trondheim, NORWAY.
 *  http://www.sim.no/  sales@sim.no  coin-support@coin3d.org
 *
\**************************************************************************/

package org.coin3d;

import java.lang.ref.*;
import java.util.*;

public class RefQ
{
    public static ReferenceQueue refq = new ReferenceQueue();
    private static Map m = new HashMap();

    public static void regGcImpl(Reference r, Deletable l)
    {
        m.put(r, l);
    }

    public static void poll()
    {
        Reference r;
        while ( (r=refq.poll()) != null) {
            Deletable d;
            if ( (d=(Deletable)m.remove(r)) != null) d.delete();
        }
    }
}

