#ifndef SO_NETWORK_H_INCLUDED_
#define SO_NETWORK_H_INCLUDED_


#include <Inventor/SbBasic.h>
#include "SbNetBasic.h"
class SoComputer;
class SoDistributionGroup;


class COIN_DLL_API SoNetwork { // FIXME: or SoLocalhost, or SoLocalHost, or SoThisComputer
public:

  static SbBool init();
  static SbBool shutdown(int timeout_ms = 0);
  static SbBool shutdownAsync();
  static void cleanup();
  static SbBool isInitialized();

  static void process();

  static const SoComputerList& getComputerList();
  static const SoDistributionGroupList& getDistributionGroupList();

  static SbBool isProcessing();

  static SbBool disconnectAllComputers(int timeout_ms = 0, SbBool dropAfterTimeout = TRUE);
  static SbBool disconnectAllComputersAsync();
  static void closeAllListeners();

  static void getIPAddresses(SbInetIPList &list);

  // FIXME: need something like static SoComputer* getLocalHost();

  // Connecting
  static SoComputer* connect(const SbInetAddr &addr);
  static SoComputer* connect(const SbInetAddr &addr, const SbInetAddr &localAddr);
  // static SoComputer* connectBySocket(int socket); ????

  // Accepting


  // missing: DNS, string conversions

  // distribution group
  static SoDistributionGroup* getDefaultDistributionGroup();
  static void setDefaultDistributionGroup(SoDistributionGroup *dg);

  // this computer
  static SoComputer* getThisComputer();

  // system functions
  static void sleep(int ms);
};


#endif /* SO_NETWORK_H_INCLUDED_ */
