#ifndef SB_TIME_STAMP_H_INCLUDED_
#define SB_TIME_STAMP_H_INCLUDED_


#include <Inventor/SbBasic.h>
#include <Inventor/cve/SbNetBasic.h>

class SoInput;
class SoOutput;
class SoComputer;
class SoDistributionGroup;



class COIN_DLL_API SbTimeStamp {
private:
  double time;      // time of timestamp generated from realTime field
  SbComputerIdentity compId; // unique identification of the application composed of
                             // ip address and pid (process identification number)
  uint32_t counter; // logical counter to distinguish timestamps that were created
                    // at the same time period between two realTime field updates

public:
  static SbTimeStamp generate(SoDistributionGroup *dg);
  static const SbTimeStamp& zero();
  SbBool isZero() const;

  SbTimeStamp();
  SbTimeStamp(const SbTimeStamp &ts);
  SbTimeStamp(const double time, const SbComputerIdentity &compId, const uint32_t counter);
  ~SbTimeStamp();

  const double& getTime() const;
  SoComputer* getComputer() const;
  const SbComputerIdentity& getComputerIdentity() const;
  int getCounter() const;
  SbString getString() const;

  int operator== (const SbTimeStamp &ts) const;
  int operator!= (const SbTimeStamp &ts) const;
  SbBool operator<  (const SbTimeStamp &ts) const;
  SbBool operator>  (const SbTimeStamp &ts) const;
  SbBool operator<= (const SbTimeStamp &ts) const;
  SbBool operator>= (const SbTimeStamp &ts) const;

  SbBool read(SoInput *in, SoDistributionGroup *dg);
  void write(SoOutput *out, SoDistributionGroup *dg) const;

  SbString get(SoDistributionGroup *dg) const;
  SbBool set(const char *string, SoDistributionGroup *dg);

  static SbBool adjustGeneratorFloor(const SbTimeStamp &ts);

private:
  static void cleanup();
};


#endif /* SB_TIME_STAMP_H_INCLUDED_ */
