#ifndef SB_SCENE_ASSERT_H_INCLUDED_
#define SB_SCENE_ASSERT_H_INCLUDED_

#include <Inventor/SbBasic.h>


#define SB_SCENE_ASSERT_HEADER() \
public: \
  static SoType getClassTypeId(void); \
  virtual SoType getTypeId(void) const; \
private: \
  static SoType classTypeId; \
  static void * createInstance(void)

#define SB_SCENE_ASSERT_SOURCE(_class_) \
SoType _class_::getClassTypeId(void) { return _class_::classTypeId; } \
SoType _class_::getTypeId(void) const { return _class_::classTypeId; } \
/* Don't set value explicitly to SoType::badType(), to avoid a bug in */ \
/* Sun CC v4.0. (Bitpattern 0x0000 equals SoType::badType()). */ \
SoType _class_::classTypeId; \
 \
void* _class_::createInstance(void) \
{ \
  return new _class_; \
}


class COIN_DLL_API SbSceneAssert {
public:
  static void initClass(void);
  virtual SoType getTypeId(void) const = 0;
  SbBool isOfType(SoType type) const;
  static SoType getClassTypeId(void);

  SbSceneAssert();
  SbSceneAssert(SoDistributionGroup *dg);
  virtual ~SbSceneAssert();

  SoDistributionGroup* getDistributionGroup() const;
  void setDistributionGroup(SoDistributionGroup *dg);
  int getName() const;

  virtual SbBool check(const SbTransaction *t, SbBool checkForCommit) = 0;

  virtual SbBool read(SoInput *in);
  virtual void write(SoOutput *out);

private:
  static SoType classTypeId;

  SoDistributionGroup *dgroup;
};


#endif /* SB_SCENE_ASSERT_H_INCLUDED_ */
