#ifndef SB_NET_LISTENER_H_INCLUDED_
#define SB_NET_LISTENER_H_INCLUDED_

#include "SbRefObject.h"
#include "SbNetBasic.h"
class SoComputer;


class COIN_DLL_API SbNetListener : public SbRefObject {
private:
  SbNetConnection lcon;
  SbInetAddr addr;

protected:
  virtual ~SbNetListener();

public:
  SbNetListener();
  SbNetListener(SbInetPort port);
  SbNetListener(const SbInetAddr &ia);
  SbNetListener(SbInetIP ip, SbInetPort port);

  void setAddr(const SbInetAddr &addr);
  const SbInetAddr& getAddr() const;

  SbBool listen();
  void close();
  SbBool isListening() const;

  SoComputer* accept() const;
  SbNetConnection acceptPlaneConnection() const;
};


#endif /* SB_NET_LISTENER_H_INCLUDED_ */
