#ifndef SB_NET_BASIC_H_INCLUDED_
#define SB_NET_BASIC_H_INCLUDED_


#include <Inventor/lists/SbList.h>
class SbString;
class SoDistributionGroup;


typedef int32_t SbNetConnection; // FIXME: the function for converting SbNetConnection
                                 // into the SOCKET is missing

typedef uint32_t SbInetIP;
typedef uint16_t SbInetPort;


class COIN_DLL_API SbInetAddr { // FIXME: resolve address/networkTarget naming mismatch
private:
  SbInetIP ip;
  SbInetPort port;

public:
  SbInetAddr() {}
  SbInetAddr(const SbInetAddr &ia) { ip=ia.ip; port=ia.port; }
  SbInetAddr(SbInetIP ip, SbInetPort port = 0) { this->ip=ip; this->port=port; }
  SbInetAddr(const char *s);

  inline const SbInetIP& getIP() const { return ip; }
  inline const SbInetPort& getPort() const { return port; }
  void setIP(const SbInetIP v);
  void setPort(const SbInetPort v);

  void setValue(const SbInetAddr &ia) { ip=ia.ip; port=ia.port; }
  void setValue(SbInetIP ip, SbInetPort port) { this->ip=ip; this->port=port; }
  SbInetAddr& operator= (const SbInetAddr &ia) { ip=ia.ip; port=ia.port; return *this; }

  SbString getString() const;
  SbBool setString(const char *s);
  SbBool setString(const char *ptr, char **endptr);

  static SbString ipToString(SbInetIP ip);
  static SbBool stringToIP(const char *s, SbInetIP &ip, const char **endptr = NULL);
  static SbString portToString(SbInetPort port);
  static SbBool stringToPort(const char *s, SbInetPort &port, const char **endptr = NULL);

  int operator== (const SbInetAddr &ia) const;
  int operator!= (const SbInetAddr &ia) const;
  
  static SbInetAddr invalid();
  SbBool isValid() const;
  void makeInvalid();
};


typedef SbList<SbInetAddr> SbInetAddrList;
typedef SbList<SbInetIP> SbInetIPList;
typedef SbList<SbInetPort> SbInetPortList;

class SoComputer;
typedef SbList<SoComputer*> SoComputerList;
class SoDistributionGroup;
typedef SbList<SoDistributionGroup*> SoDistributionGroupList;


// SbComputerIdentity
//
// unique identification composed of 
// ip address and pid (process identification number)
typedef struct SbComputerIdentity {
  SoDistributionGroup *dg;
  int32_t id;
  
  SbComputerIdentity() : dg(NULL), id(-1)  {}
  SbComputerIdentity(SoDistributionGroup * const dg, const int32_t id);

  SbBool isValid() const;
} SbComputerIdentity;

SbBool operator== (const SbComputerIdentity &ci1, const SbComputerIdentity &ci2);
SbBool operator!= (const SbComputerIdentity &ci1, const SbComputerIdentity &ci2);


#endif /* SB_NET_BASIC_H_INCLUDED_ */
