#! /bin/sh
#
# This script generates the Visual Studio 6 build files for Windows.
#
# 20041214 larsa

rm -rf src
rm -f coin2.dsp coin2.dsw coin2.vcproj coin2.sln install-headers.bat

build_pwd=`pwd`
build="`cygpath -w $build_pwd | sed -e 's/\\\\/\\\\\\\\/g'`"
build_pwd="`pwd | sed -e 's/\\//\\\\\\\\/g'`\\\\"

source_pwd=`cd ../..; pwd`
source="`cygpath -w $source_pwd | sed -e 's/\\\\/\\\\\\\\/g'`"
source_pwd="`(cd ../..; pwd) | sed -e 's/\\//\\\\\\\\/g'`"

../../configure --with-msvcrt=mtd --with-suffix=d \
  --enable-debug --enable-symbols || exit 1
cp include/config.h include/config-debug.h

../../configure --with-msvcrt=mt \
  --disable-debug --disable-symbols --enable-optimization || exit 1
cp include/config.h include/config-release.h

cp config-wrapper.h include/config.h

( make 2>&1 | tee generate.log ) || exit 1

# Generating the project files is slow - just doing a compile (for making
# sure the built source files are up to date) is faster, and then we can
# just copy the project files from the msvc6 setup...
#
#sed \
#  -e "s/$build/./g" \
#  -e "s/$build_pwd//g" \
#  -e "s/$source/..\\\\../g" \
#  -e "s/$source_pwd/..\\\\../g" \
#  -e 's/$/\r/g' \
#  <coin2.dsp >new.dsp
#
#mv new.dsp coin2.dsp
#
#sed \
#  -e "s/$build/./g" \
#  -e "s/$build_pwd//g" \
#  -e "s/$source/..\\\\../g" \
#  -e "s/$source_pwd/..\\\\../g" \
#  -e 's/$/\r/g' \
#  <installcoinheaders.bat >new.bat
#
#mv new.bat installcoinheaders.bat

cp ../msvc6/coin2.dsw ../msvc6/coin2.dsp ../msvc6/install-headers.bat .

echo "Now upgrade the project files to MSVC7.1..."
echo "Hopefully you remembered to generate in msvc6 first."
echo "Do: devenv coin2.dsw"

# How can I avoid the modal upgrade prompt-dialog for MSVC7.1 here???
# devenv /command "File.OpenProject $build\\coin2.dsp"

