#!/bin/bash

# Before running this script, please
# - install cygwin, including wget
# - make sure you've done cvs login to cvs.coin3d.org

COINBUILD_CRT_LIST="md mdd"
COINBUILD_SOUND_LIST="no"

COINBUILD_PARAMS_OK="no"

if test $# -eq 1; then
  COINBUILD_PARAMS_OK="yes"
fi

if test $# -eq 3; then
  COINBUILD_PARAMS_OK="yes"
fi

if test "X$COINBUILD_PARAMS_OK" = "Xno"; then
  echo "Usage: build_coin_win32.sh <target dir>"
#  echo "       build_coin_sin32.sh <checkout dir> <config dir> <inst dir>"
  echo ""
  echo "Ex:    build_coin_win32.sh /cygdrive/c/Coin3D"
  echo ""
#  echo "       If the first syntax is used, target dir will be created, and it"
#  echo "       will contain three subdirectories named \"checkout\","
#  echo "       \"configure\", and \"install\"."
#  echo "       If the second syntax is used, the three specified directories"
#  echo "       are used instead of one top-level directory (target dir)."
#  echo ""
  echo "       The script will download and build Coin-2 and all dependent"
  echo "       libraries. If something fails during this process, try fixing"
  echo "       the problem based on the error messages, then _delete_ the"
  echo "       directories affected by the error. This is important because"
  echo "       the script has not been built to be able to continue after"
  echo "       any error."
  echo ""
  echo "       After the script has completed, the \"install\" directory will"
  echo "       contain a binary release of coin, including all dependant"
  echo "       libraries. This release consists of 8 different configurations"
  echo "       using four different CRTs (MT MTD MD MDD), with and without"
  echo "       sound support."
  echo ""
  exit
fi

if test $# -eq 1; then
  if ! test -d $1; then
    echo "[COIN-2]      Creating directory $1"
    mkdir $1
  fi
  COINBUILD_CHECKOUT=$1/checkout
  COINBUILD_CONFIGURE=$1/configure
  COINBUILD_INSTALL=$1/install
fi

#if test $# -eq 3; then
#  COINBUILD_CHECKOUT=$2
#  COINBUILD_CONFIGURE=$3
#  COINBUILD_INSTALL=$4
#fi

if ! test -d $COINBUILD_CHECKOUT; then
  echo "[COIN-2]   Creating directory $COINBUILD_CHECKOUT"
  mkdir $COINBUILD_CHECKOUT
fi

if ! test -d $COINBUILD_CHECKOUT; then
  echo "[COIN-2]   Couldn\'t create directory $COINBUILD_CHECKOUT. Aborting."
  exit
fi

if ! test -d $COINBUILD_CONFIGURE; then
  echo "[COIN-2]   Creating directory $COINBUILD_CONFIGURE"
  mkdir $COINBUILD_CONFIGURE
fi

if ! test -d $COINBUILD_CONFIGURE; then
  echo "[COIN-2]   Couldn\'t create directory $COINBUILD_CONFIGURE. Aborting."
  exit
fi

if ! test -d $COINBUILD_INSTALL; then
  echo "[COIN-2]   Creating directory $COINBUILD_INSTALL"
  mkdir $COINBUILD_INSTALL
fi

if ! test -d $COINBUILD_INSTALL; then
  echo "[COIN-2]   Couldn\'t create directory $COINBUILD_INSTALL. Aborting."
  exit
fi

function set_coin_param_crt()
{
  if test "X$COINBUILD_CRT" = "Xmt"; then COINBUILD_PARAMCRT="MT"; fi
  if test "X$COINBUILD_CRT" = "Xmtd"; then COINBUILD_PARAMCRT="MTd"; fi
  if test "X$COINBUILD_CRT" = "Xmd"; then COINBUILD_PARAMCRT="MD"; fi
  if test "X$COINBUILD_CRT" = "Xmdd"; then COINBUILD_PARAMCRT="MDd"; fi
}

# cvs update simage

if ! test -d $COINBUILD_CHECKOUT/simage; then
  echo "[COIN-2]      Checking out simage from scratch"
  cd $COINBUILD_CHECKOUT
  cvs -z3 -d:pserver:cvs@cvs.coin3d.org:/export/cvsroot co simage
else
  echo "[COIN-2]      Updating simage"
  cd $COINBUILD_CHECKOUT/simage
  cvs -z3 update -dP
fi

# build simage

# $COINBUILD_CHECKOUT/simage/build/build_simage_win32.sh $1

# cvs update Coin-2

if ! test -d $COINBUILD_CHECKOUT/Coin-2; then
  echo "[COIN-2]      Checking out Coin-2 from scratch"
  cd $COINBUILD_CHECKOUT
  cvs -z3 -d:pserver:cvs@cvs.coin3d.org:/export/cvsroot co Coin-2
else
  echo "[COIN-2]      Updating Coin-2"
  cd $COINBUILD_CHECKOUT/Coin-2
  cvs -z3 update -dP
fi

# configure and make coinbuild

echo "[COIN-2]      Configuring Coin-2"

for COINBUILD_SOUND in $COINBUILD_SOUND_LIST; do

  if test "X$COINBUILD_SOUND" = "Xyes"; then
    COINBUILD_SOUND_DIRNAME="with_sound"
    COINBUILD_SOUND_NAME="s_"
  else
    COINBUILD_SOUND_DIRNAME="without_sound"
    COINBUILD_SOUND_NAME=""
  fi

  if ! test -d $COINBUILD_CONFIGURE/Coin-2; then
    echo "[COIN-2]         Creating directory $COINBUILD_CONFIGURE/Coin-2"
    mkdir $COINBUILD_CONFIGURE/Coin-2
  fi

  if ! test -d $COINBUILD_CONFIGURE/Coin-2/$COINBUILD_SOUND_DIRNAME; then
    echo "[COIN-2]         Creating directory $COINBUILD_CONFIGURE/Coin-2/$COINBUILD_SOUND_DIRNAME"
    mkdir $COINBUILD_CONFIGURE/Coin-2/$COINBUILD_SOUND_DIRNAME
  fi

  for COINBUILD_CRT in $COINBUILD_CRT_LIST; do

    if ! test -d $COINBUILD_CONFIGURE/Coin-2/$COINBUILD_SOUND_DIRNAME/$COINBUILD_CRT; then
      echo "[COIN-2]         Creating directory $COINBUILD_CONFIGURE/Coin-2/$COINBUILD_SOUND_DIRNAME/$COINBUILD_CRT"
      mkdir $COINBUILD_CONFIGURE/Coin-2/$COINBUILD_SOUND_DIRNAME/$COINBUILD_CRT
    fi

    cd $COINBUILD_CONFIGURE/Coin-2/$COINBUILD_SOUND_DIRNAME/$COINBUILD_CRT

    if test -e "config.status"; then
      echo "[COIN-2]         Rechecking existing configuration in Coin-2/$COINBUILD_SOUND_DIRNAME/$COINBUILD_CRT"
      ./config.status --recheck && ./config.status
    else
      echo "[COIN-2]         Configuring from scratch in Coin-2/$COINBUILD_SOUND_DIRNAME/$COINBUILD_CRT"

      COINBUILD_SUFFIX=_$COINBUILD_SOUND_NAME$COINBUILD_CRT
      if test "X$COINBUILD_CRT" = "Xmd"; then
        COINBUILD_SUFFIX=
      elif test "X$COINBUILD_CRT" = "Xmdd"; then
        COINBUILD_SUFFIX=d
      fi

      COINBUILD_EXTRAFLAGS1=""
      if test "X$COINBUILD_CRT" = "Xmd"; then
        COINBUILD_EXTRAFLAGS1="--disable-debug --disable-symbols"
      elif test "X$COINBUILD_CRT" = "Xmt"; then
        COINBUILD_EXTRAFLAGS1="--disable-debug --disable-symbols"
      fi

      if test "X$COINBUILD_SOUND" = "Xyes"; then
        COINBUILD_EXTRAFLAGS2=""
      else
        COINBUILD_EXTRAFLAGS2="--disable-sound"
      fi

      $COINBUILD_CHECKOUT/Coin-2/configure --enable-threads --enable-threadsafe --with-msvcrt=$COINBUILD_CRT --with-suffix=$COINBUILD_SUFFIX --with-alternate=$COINBUILD_SOUND_NAME$COINBUILD_CRT --prefix=$COINBUILD_INSTALL $COINBUILD_EXTRAFLAGS1 $COINBUILD_EXTRAFLAGS2 --with-simage=$COINBUILD_INSTAL --disable-dl-simage 

    fi

    echo "[COIN-2]         Making install in Coin-2/$COINBUILD_CRT"
    make install

  done # for COINBUILD_CRT

done # for COINBUILD_SOUND

echo "[COIN-2]   All systems ready to go"


