//---------------------------------------------------------------------------
// pyramid.h
// Pyramidal image representation
//---------------------------------------------------------------------------

#ifndef _PYRAMID_H_
#define _PYRAMID_H_


#include <vector>
#include <cmath>
#include "imagetools.h"


class TImagePyramid
{
	typedef std::vector<TFrame*> TFrameList;
	typedef std::vector<int*> TTableList;

	TSize size; ///< Input image size
	float factor; ///< scale level
	TFrameList pyramid; ///< pyramid levels
	TTableList rescaleTabs;

	TSize getLevelSize(int level)
	{
		return TSize(
			int(std::floor(size.w / getLevelFactor(level))),
			int(std::floor(size.h / getLevelFactor(level))));
	}

public:
	TImagePyramid(TSize sz, float f, int l);

	~TImagePyramid();

	void insert(TImageUChar & image);

	TImageUChar & image(int level)
	{
		return pyramid[level]->intensityImage();
	}

	float getLevelFactor(int level)
	{
		return std::pow(factor, level);
	}

	
	TFrame & frame(int level)
	{
		return *(pyramid[level]);
	}

	std::size_t levels()
	{
		return pyramid.size();
	}
};

#endif
