#include "pyramid.h"

using namespace std;

TImagePyramid::TImagePyramid(TSize sz, float f, int l)
	:size(sz), factor(f)
{
	// allocate images in all pyramid levels

	int tablesize = max(sz.w, sz.h);
	for (int i = 0; i < l; ++i)
	{
		TSize s = getLevelSize(i);
		pyramid.push_back(new TFrame(s));

		rescaleTabs.push_back(new int[tablesize]);
		
		float scale = float(sz.h) / s.h;
		for (int i = 0; i < tablesize; ++i)
		{
			rescaleTabs.back()[i] = int(floor(scale * i));
		}
	}
}


TImagePyramid::~TImagePyramid()
{
	pyramid.clear();
	rescaleTabs.clear();
}


void TImagePyramid::insert(TImageUChar & image)
{
	TTableList::iterator r = rescaleTabs.begin();
	for (TFrameList::iterator f = pyramid.begin(); f != pyramid.end(); ++f, ++r)
	{
		TFrame & frame = **f;
		frame.insert(image, *r);
	}
}
