#include <cv.h>
#include <highgui.h>
#include "imagetools.h"

TImageUChar IplImageReferenceUChar(IplImage * image, bool vflip)
{
	if (vflip)
	{
		return TImageUChar(
			TImageUChar::TImageDataPtr(image->imageData)+((image->height-1)*image->widthStep),
			TSize(image->width, image->height),
			-image->widthStep);
	}
	else
	{
		return TImageUChar(
			TImageUChar::TImageDataPtr(image->imageData),
			TSize(image->width, image->height),
			image->widthStep);
	}
}


TImageFloat IplImageReferenceFloat(IplImage * image, bool vflip)
{
	if (vflip)
	{
		return TImageFloat(
			TImageFloat::TImageDataPtr(image->imageData+((image->height-1)*image->widthStep)),
			TSize(image->width, image->height),
			-image->widthStep);
	}
	else
	{
		return TImageFloat(
			TImageFloat::TImageDataPtr(image->imageData),
			TSize(image->width, image->height),
			image->widthStep);
	}
}


void process(IplImage * input, IplImage * output)
{
    TImageUChar in = IplImageReferenceUChar(input, false);
    TImageFloat out = IplImageReferenceFloat(output, false);

    for (int y = 0; y < in.size().h; ++y)
        for (int x = 0; x < in.size().w; ++x)
        {
            out.row(y)[x] += float(in.row(y)[x]) / 256.0;
        }
}

int main()
{
    CvCapture * capture = cvCaptureFromCAM(0);
    IplImage * frame = 0;
    IplImage * gray = 0;
    IplImage * output = 0;

    cvNamedWindow("image");
    for (;;)
    {
        if (!cvGrabFrame(capture)) break;

        frame = cvRetrieveFrame(capture);

        if (!output)
            output = cvCreateImage(cvSize(frame->width, frame->height), IPL_DEPTH_32F, 1);
        if (!gray)
            output = cvCreateImage(cvSize(frame->width, frame->height), IPL_DEPTH_8U, 1);

        cvCvtColor(frame, gray, CV_RGB2GRAY);

        process(gray, output);

        cvShowImage("image", output);

        if (cvWaitKey(10) >= 0) break;
    }
}
