//---------------------------------------------------------------------------

#include "imagetools.h"
#include <numeric>
#include <cmath>
#include <cassert>


using namespace std;


//---------------------------------------------------------------------------

// \todo fix calculation!!!!!!
void TSampleImage::integrate(unsigned & sum, unsigned & sum2)
{
	sum2 = 0;
	TImageUInt::TImageDataPtr dstbase = integral.row(0);
	TImageUChar::TImageDataPtr srcbase = intensity.row(0);

	// top-left corner
	*dstbase = *srcbase;
	++srcbase, ++dstbase;
	sum2 += *srcbase * *srcbase;
	// first row
	for (int x = 1; x < intensity.size().w; ++x, ++srcbase, ++dstbase)
	{
		*dstbase = *srcbase + *(dstbase-1);
		sum2 += *srcbase * *srcbase;
	}

	// rest of image
	for (int y = 1; y < intensity.size().h; ++y)
	{
		srcbase = intensity.row(y);
		dstbase = integral.row(y);
		TImageUInt::TImageDataPtr dsttmpbase = integral.row(y-1);
		unsigned tmp = 0;
		for (int x = 0; x < intensity.size().w; ++x, ++srcbase, ++dstbase, ++dsttmpbase)
		{
			tmp += *srcbase;
			*dstbase = tmp + *dsttmpbase;
			sum2 += *srcbase * *srcbase;
		}
	}

	// sum of all pixels is in bottom-right pixel of integral image
	sum = integral.row(integral.size().h)[integral.size().w-1];
}


void integrate(const TImageUChar & image, TImageUInt & sum1, TImageUInt & sum2)
{
	assert(image.size() == sum1.size() && image.size() == sum2.size() && "Bad image size!");

	TImageUChar::TImageDataPtr srcbase = image.row(0);
	TImageUInt::TImageDataPtr dstbase1 = sum1.row(0);
	TImageUInt::TImageDataPtr dstbase2 = sum2.row(0);

	// top-left corner
	*dstbase1 = *srcbase;
	*dstbase2 = *srcbase * *srcbase;
	++srcbase, ++dstbase1, ++dstbase2;

	// first row
	for (int x = 1; x < image.size().w; ++x, ++srcbase, ++dstbase1, ++dstbase2)
	{
		*dstbase1 = *(dstbase1-1) + *srcbase;
		*dstbase2 = *(dstbase2-1) + (*srcbase * *srcbase);
	}

	// rest of image
	for (int y = 1; y < image.size().h; ++y)
	{
		srcbase = image.row(y);
		dstbase1 = sum1.row(y);
		dstbase2 = sum2.row(y);
		TImageUInt::TImageDataPtr dsttmpbase1 = sum1.row(y-1);
		TImageUInt::TImageDataPtr dsttmpbase2 = sum2.row(y-1);

		unsigned tmp1 = 0;
		unsigned tmp2 = 0;

		for (int x = 0; x < image.size().w; ++x, ++srcbase, ++dstbase1, ++dsttmpbase1, ++dstbase2, ++dsttmpbase2)
		{
			tmp1 += *srcbase;
			tmp2 += *srcbase * *srcbase;

			*dstbase1 = tmp1 + *dsttmpbase1;
			*dstbase2 = tmp2 + *dsttmpbase2;
		}
	}
}


/// calculate resize table.
int * calcScaleTable(float scale, int size)
{
	int * table = new int[size];
	float f = 0.0f;
	for (int * t = table; t < table+size; ++t, f+=scale)
	{
		*t = int(floor(f));
	}
	return table;
}


void remapImage(TImageUChar & src, TImageUChar & dst, int * xtable, int * ytable)
{
	bool deleteXScale = (xtable == 0);
	bool deleteYScale = (ytable == 0);

	if (!xtable)
	{
		float scaleX = float(src.size().w) / dst.size().w;
		xtable = calcScaleTable(scaleX, dst.size().w);
	}

	if (!ytable)
	{
		float scaleY = float(src.size().h) / dst.size().h;
		ytable = calcScaleTable(scaleY, dst.size().h);
	}

	for (int y = 0; y < dst.size().h; ++y)
	{
		TImageUChar::TImageDataPtr dstpx = dst.row(y);
		const TImageUChar::TImageDataPtr srcrow = src.row(ytable[y]);
		int * srcx = xtable;
		for (int x = 0; x < dst.size().w; ++x, ++dstpx, ++srcx)
		{
			*dstpx = srcrow[*srcx];
		}
	}

	if (deleteXScale) delete[] xtable;
	if (deleteYScale) delete[] ytable;
}

void convolve(TImageUChar * srcImage, TImageUChar * dstImage, int * kernel, int size, int scale)
{
	if (!srcImage) return; // OMG! No image to filter.

	TImageUChar tmpImage(srcImage->size());
	TImageUChar & image = *srcImage;
	TImageUChar & result = (dstImage) ? *dstImage : *srcImage;
	
	assert(srcImage->size() == dstImage->size());
	
	// horizontal convolution
	// image -> tmpImage
	for (int y = 0; y < image.size().h; ++y)
	{
		TImageUChar::TImageDataPtr srcpx = image.row(y);
		TImageUChar::TImageDataPtr dstpx = tmpImage.row(y)+(size/2);

		for (int x = 1; x < image.size().w-size; ++x, ++srcpx, ++dstpx)
		{
			int r = 0;
			TImageUChar::TImageDataPtr m = srcpx;
			for (int * k = kernel; k < kernel+size; ++k, ++m)
			{
				r += *k * *m;
			}
			*dstpx = r / scale;
		}
	}
	
	// vertical convolution
	// tmpImage -> result
	TImageUChar::TImageDataPtr srccolbase = tmpImage.row(0);
	TImageUChar::TImageDataPtr dstcolbase = result.row(0);
	for (; srccolbase < tmpImage.row(0)+image.size().w; ++srccolbase, ++dstcolbase)
	{
		TImageUChar::TDataPtr srcpx = TImageUChar::TDataPtr(srccolbase);
		TImageUChar::TDataPtr dstpx = TImageUChar::TDataPtr(dstcolbase);

		for (int y = 0; y < image.size().h-size; ++y, srcpx+=tmpImage.yOffset(), dstpx+=result.yOffset())
		{
			int r = 0;
			TImageUChar::TDataPtr m = srcpx;
			for (int k = 0; k < size; ++k, m+=tmpImage.yOffset())
			{
				r += kernel[k] * *TImageUChar::TImageDataPtr(m);
			}
			*TImageUChar::TImageDataPtr(dstpx) = r / scale;
		}
	}

}
