//---------------------------------------------------------------------------
#include <iostream>
#include "features.h"

using namespace std;
//////////////////////////////////////////////////////////////////////////////

// THaarDoubleHorizontal ---------------------------------------------------------

int THaarDoubleHorizontal::loadFromXML(xmlNodePtr root)
{
    if (!root) return 0;

    xmlNodePtr fNode = getNode("HaarHorizontalDoubleFeature", root);
    if (!fNode)
	{
        return 0;
	}

    bool ok = true;

    if (!getAttr(x, "positionX", fNode)) ok = false;
    if (!getAttr(y, "positionY", fNode)) ok = false;
    if (!getAttr(bw, "blockWidth", fNode)) ok = false;
    if (!getAttr(bh, "blockHeight", fNode)) ok = false;

    if (!ok) return 0;

    blockSize = float(bw * bh);
    return 1;
}

// THaarDoubleVertical ---------------------------------------------------------

int THaarDoubleVertical::loadFromXML(xmlNodePtr root)
{
    if (!root) return 0;

    xmlNodePtr fNode = getNode("HaarVerticalDoubleFeature", root);
    if (!fNode)
        return 0;

    bool ok = true;

    if (!getAttr(x, "positionX", fNode)) ok = false;
    if (!getAttr(y, "positionY", fNode)) ok = false;
    if (!getAttr(bw, "blockWidth", fNode)) ok = false;
    if (!getAttr(bh, "blockHeight", fNode)) ok = false;

    // cout << "x: " << x << "y: " << y << "w: " << bw << "h: " << bh << endl; 
    if (!ok) return 0;

    blockSize = float(bw * bh);

    return 1;
}


// THaarTripleHorizontal -------------------------------------------------------

int THaarTripleHorizontal::loadFromXML(xmlNodePtr root)
{
    if (!root) return 0;

    xmlNodePtr fNode = getNode("HaarHorizontalTernalFeature", root);
    if (!fNode)
        return 0;

    bool ok = true;

    if (!getAttr(x, "positionX", fNode)) ok = false;
    if (!getAttr(y, "positionY", fNode)) ok = false;
    if (!getAttr(bw, "blockWidth", fNode)) ok = false;
    if (!getAttr(bh, "blockHeight", fNode)) ok = false;

    // cout << "x: " << x << "y: " << y << "w: " << bw << "h: " << bh << endl; 
    if (!ok) return 0;

    blockSize = float(bw * bh);

    return 1;
}


// THaarTripleVertical ---------------------------------------------------------

int THaarTripleVertical::loadFromXML(xmlNodePtr root)
{
    if (!root) return 0;

    xmlNodePtr fNode = getNode("HaarVerticalTernalFeature", root);
    if (!fNode)
        return 0;

    bool ok = true;

    if (!getAttr(x, "positionX", fNode)) ok = false;
    if (!getAttr(y, "positionY", fNode)) ok = false;
    if (!getAttr(bw, "blockWidth", fNode)) ok = false;
    if (!getAttr(bh, "blockHeight", fNode)) ok = false;

    // cout << "x: " << x << "y: " << y << "w: " << bw << "h: " << bh << endl; 

    if (!ok) return 0;

    blockSize = float(bw * bh);

    return 1;
}


TContFeature * createContFeature(const xmlNodePtr node)
{
    {
        THaarDoubleHorizontal * feature = new THaarDoubleHorizontal();
        if (feature->loadFromXML(node))
        {
            return feature;
        }
        else
            delete feature;
    }

    {
        THaarDoubleVertical * feature = new THaarDoubleVertical();
        if (feature->loadFromXML(node))
        {
            return feature;
        }
        else
            delete feature;
    }

    {
        THaarTripleVertical * feature = new THaarTripleVertical();
        if (feature->loadFromXML(node))
        {
            return feature;
        }
        else
            delete feature;
    }

    {
        THaarTripleHorizontal * feature = new THaarTripleHorizontal();
        if (feature->loadFromXML(node))
        {
            return feature;
        }
        else
            delete feature;
    }

    return 0; // No contructible feature found
}
