#ifndef _COMMON_H_
#define _COMMON_H_
// common.h
// General useful functions

#include <string>
#include <sstream>

/// Convert string to any type.
/// Optionally checks if whole string was converted.
/// When no string given (str==0) default value for _T is assigned output variable. 
/// @param str String to convert
/// @param value Destination for converted value
/// @param check Check leftover characters flag (default true)
/// @param f Base for conversion (default std::dec)
/// \returns Flag signalizing successful conversion
template <class _T>
bool strConvert(const char * str, _T & value, bool check = true, std::ios_base & (*f)(std::ios_base&) = std::dec)
{
	if (!str)
	{
		value = _T();
		return false;
	}
	std::istringstream iss(str);
	char c;
	//!(!(iss >> f >> value) || (check && iss.get(c)));
	return (iss >> f >> value) && !(check && iss.get(c));
}

#endif
