/*
 *  $Id: demo.cpp 9 2008-05-02 08:14:34Z andyman $
 *
 *  LRD evaluation demonstration
 *  The program takes video from camera, scans the image and displays the
 *  detections.
 *  q: Quit application
 *  t/T: decrease/increase detection threshold
 */

#include <iostream>
#include <vector>

#include <cv.h>
#include <cxcore.h>
#include <highgui.h>

#include "lrd_engine.h"
#include "faces.h"

using namespace std;


int main()
{
	CvCapture * capture = cvCaptureFromCAM(0);

	if (!capture)
	{
		cerr << "No camera found!" << endl;
		return 0;
	}

	IplImage * inputFrame = 0; // Frame from camera
	IplImage * grayFrame = 0;  // Input frame converted to grayscale
	vector<IplImage*> pyramid(6); // Rescaled images - for multiscale image scan
	// pyramid parameters
    float pyrFactor = 1.25f;
	float scaleBase = 3.5f;
    
    initClassifier(&classifier); // Initialization of a classifier
    
	TDetectionList results(1000); // Allocation of result vector

	cvNamedWindow("Image");

	for (;;)
	{
		if (!cvGrabFrame(capture)) break;
		inputFrame = cvRetrieveFrame(capture);

		// Init images
		if (!grayFrame)
		{
			grayFrame = cvCreateImage(cvSize(inputFrame->width, inputFrame->height), IPL_DEPTH_8U, 1);
			for (unsigned i = 0; i < pyramid.size(); ++i) // prepare images in different resolutions
			{
				float factor = scaleBase * pow(pyrFactor, float(i));
				CvSize levelSize = cvSize(int(inputFrame->width/factor), int(inputFrame->height/factor));
				pyramid[i] = cvCreateImage(levelSize, IPL_DEPTH_8U, 1);
			}
		}
        
		// flip if needed
        if (inputFrame->origin)
        {
            inputFrame->origin = 0;
            cvFlip(inputFrame);
        }

		cvCvtColor(inputFrame, grayFrame, CV_RGB2GRAY);
		//cvSmooth(grayFrame, grayFrame, CV_GAUSSIAN, 11);

		for (unsigned i = 0; i < pyramid.size(); ++i)
		{
			cvResize(grayFrame, pyramid[i], CV_INTER_NN);
            
            setClassifierImageSize(&classifier, pyramid[i]->widthStep);

            // Scan the image and draw results
			results.count = 0;
			int n = scanImage(pyramid[i], &classifier, &results, 0);

            for (unsigned res = 0; res < n; ++res)
			{
				float factor = scaleBase * pow(pyrFactor, float(i));
				CvRect & r = results.detections[res].area;
				r.x *= factor, r.y *= factor, r.width *= factor, r.height *= factor;
				cvRectangle(inputFrame, cvPoint(r.x-1,r.y-1), cvPoint(r.x+r.width+1,r.y+r.height+1), cvScalar(0,0,0));
				cvRectangle(inputFrame, cvPoint(r.x+1,r.y+1), cvPoint(r.x+r.width-1,r.y+r.height-1), cvScalar(0,0,0));
				cvRectangle(inputFrame, cvPoint(r.x,r.y), cvPoint(r.x+r.width,r.y+r.height), cvScalar(255,255,255));
			}
		}

		cvShowImage("Image", inputFrame);

		int c;
		if ((c = cvWaitKey(10)) == 'q') break;
		if (c == 'T') classifier.threshold += 0.5;
		if (c == 't') classifier.threshold -= 0.5;
		if (c >= 0)
		{
			cout << "t=" << classifier.threshold << endl;
		}
	}

	return 0;
}

