/*
  Zboril's format support routines
  Copyright (C) 2007 Jaroslav Skarvada <skarvada@fit.vutbr.cz>  
  
  This program is free software: you can redistribute it and/or modify  
  it under the terms of the GNU General Public License as published by  
  the Free Software Foundation, either version 3 of the License, or  
  (at your option) any later version.  
  
  This program is distributed in the hope that it will be useful,  
  but WITHOUT ANY WARRANTY; without even the implied warranty of  
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
  GNU General Public License for more details.  
 
  You should have received a copy of the GNU General Public License  
  along with this program.  If not, see <http://www.gnu.org/licenses/>.  
*/

#ifndef istring
#include <string>
#define istring
#endif

#ifndef ifstream
#include <fstream>
#define ifstream
#endif

#ifndef izboril
#include "zboril.h"
#define izboril
#endif

using namespace std;

// Pascal string to STL string converter
string
passtr2stl (char passtr[])
{
  int x;
  string s;

  for (x = 1; x <= passtr[0]; x++)
    s += passtr[x];

  return s;
}

// reads structure <prvek> from <f>
void
read_prvek (fstream & f, tprvek & prvek)
{
  f.read ((char *) &prvek.cislo, sizeof (prvek.cislo));
  f.read ((char *) &prvek.jmeno, sizeof (prvek.jmeno));
  f.read ((char *) &prvek.typ, sizeof (prvek.typ));
  f.read ((char *) &prvek.tzhat, sizeof (prvek.tzhat));
  f.read ((char *) &prvek.pvst, sizeof (prvek.pvst));
  f.read ((char *) &prvek.pvsvy, sizeof (prvek.pvsvy));
  f.read ((char *) &prvek.pvyst, sizeof (prvek.pvyst));
  f.read ((char *) &prvek.iprv, sizeof (prvek.iprv));
  f.read ((char *) &prvek.pvrt, sizeof (prvek.pvrt));
  f.read ((char *) &prvek.ivrt, sizeof (prvek.ivrt));
  f.read ((char *) &prvek.pvyrt, sizeof (prvek.pvyrt));
  f.read ((char *) &prvek.ivyrt, sizeof (prvek.ivyrt));
}

// reads structure <brana> from <f>
void
read_brana (fstream & f, tbrana & brana)
{
  f.read ((char *) &brana.cislo, sizeof (brana.cislo));
  f.read ((char *) &brana.jmeno, sizeof (brana.jmeno));
  f.read ((char *) &brana.typ, sizeof (brana.typ));
  f.read ((char *) &brana.iprvku, sizeof (brana.iprvku));
  f.read ((char *) &brana.sspoje, sizeof (brana.sspoje));
  f.read ((char *) &brana.ispoje, sizeof (brana.ispoje));
  f.read ((char *) &brana.pvtv_po, sizeof (brana.pvtv_po));
  f.read ((char *) &brana.ivtv_po, sizeof (brana.ivtv_po));
}

// reads structure <spoj> from <f>
void
read_spoj (fstream & f, tspoj & spoj)
{
  f.read ((char *) &spoj.cislo, sizeof (spoj.cislo));
  f.read ((char *) &spoj.jmeno, sizeof (spoj.jmeno));
  f.read ((char *) &spoj.podkud, sizeof (spoj.podkud));
  f.read ((char *) &spoj.podkam, sizeof (spoj.podkam));
  f.read ((char *) &spoj.pkam, sizeof (spoj.pkam));
  f.read ((char *) &spoj.iprv, sizeof (spoj.iprv));
  f.read ((char *) &spoj.sspoje, sizeof (spoj.sspoje));
  f.read ((char *) &spoj.prprbr, sizeof (spoj.prprbr));
}

// reads structure <spi> from <f>
void
read_spi (fstream & f, tspi & spi)
{
  f.read ((char *) &spi, sizeof (spi));
}


// STL string <stlstr> to Pascal string <passtr> converter, returns <passtr>
char *
stlstr2pas (string stlstr, char passtr[])
{
  int x, y;

  y = stlstr.length();
  if (y>255)
    y = 255;
  passtr[0] = y;
  for (x = 1; x <= y; x++)
     passtr[x] = stlstr[x-1];

  return passtr;
}

// write structure <prvek> to <f>, return status (0 = OK, otherwise error)
int
write_prvek (fstream & f, tprvek & prvek)
{
  return !(f.write ((char *) &prvek.cislo, sizeof (prvek.cislo)) &&
           f.write ((char *) &prvek.jmeno, sizeof (prvek.jmeno)) &&
           f.write ((char *) &prvek.typ, sizeof (prvek.typ)) &&
           f.write ((char *) &prvek.tzhat, sizeof (prvek.tzhat)) &&
           f.write ((char *) &prvek.pvst, sizeof (prvek.pvst)) &&
           f.write ((char *) &prvek.pvsvy, sizeof (prvek.pvsvy)) &&
           f.write ((char *) &prvek.pvyst, sizeof (prvek.pvyst)) &&
           f.write ((char *) &prvek.iprv, sizeof (prvek.iprv)) &&
           f.write ((char *) &prvek.pvrt, sizeof (prvek.pvrt)) &&
           f.write ((char *) &prvek.ivrt, sizeof (prvek.ivrt)) &&
           f.write ((char *) &prvek.pvyrt, sizeof (prvek.pvyrt)) &&
           f.write ((char *) &prvek.ivyrt, sizeof (prvek.ivyrt)));
}

// write structure <brana> to <f>, return status (0 = OK, otherwise error)
int
write_brana (fstream & f, tbrana & brana)
{
  return !(f.write ((char *) &brana.cislo, sizeof (brana.cislo)) &&
  f.write ((char *) &brana.jmeno, sizeof (brana.jmeno)) &&
  f.write ((char *) &brana.typ, sizeof (brana.typ)) &&
  f.write ((char *) &brana.iprvku, sizeof (brana.iprvku)) &&
  f.write ((char *) &brana.sspoje, sizeof (brana.sspoje)) &&
  f.write ((char *) &brana.ispoje, sizeof (brana.ispoje)) &&
  f.write ((char *) &brana.pvtv_po, sizeof (brana.pvtv_po)) &&
  f.write ((char *) &brana.ivtv_po, sizeof (brana.ivtv_po)));
}

// write structure <spoj> to <f>, return status (0 = OK, otherwise error)
int
write_spoj (fstream & f, tspoj & spoj)
{
  return !(f.write ((char *) &spoj.cislo, sizeof (spoj.cislo)) &&
  f.write ((char *) &spoj.jmeno, sizeof (spoj.jmeno)) &&
  f.write ((char *) &spoj.podkud, sizeof (spoj.podkud)) &&
  f.write ((char *) &spoj.podkam, sizeof (spoj.podkam)) &&
  f.write ((char *) &spoj.pkam, sizeof (spoj.pkam)) &&
  f.write ((char *) &spoj.iprv, sizeof (spoj.iprv)) &&
  f.write ((char *) &spoj.sspoje, sizeof (spoj.sspoje)) &&
  f.write ((char *) &spoj.prprbr, sizeof (spoj.prprbr))); 
}

// write structure <spi> to <f>, return status (0 = OK, otherwise error)
int
write_spi (fstream & f, tspi & spi)
{
  return !f.write ((char *) &spi, sizeof (spi));
}
